/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlockTile;
import net.mehvahdjukaar.advframes.network.ServerBoundSetStatFramePacket;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.LoadingDotsWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class StatSelectScreen
extends StatsScreen {
    private final StatFrameBlockTile tile;
    private static final Component TITLE = Component.translatable((String)"gui.stats");
    static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot");
    static final ResourceLocation HEADER_SPRITE = ResourceLocation.withDefaultNamespace((String)"statistics/header");
    static final ResourceLocation SORT_UP_SPRITE = ResourceLocation.withDefaultNamespace((String)"statistics/sort_up");
    static final ResourceLocation SORT_DOWN_SPRITE = ResourceLocation.withDefaultNamespace((String)"statistics/sort_down");
    private static final Component PENDING_TEXT = Component.translatable((String)"multiplayer.downloadingStats");
    static final Component NO_VALUE_DISPLAY = Component.translatable((String)"stats.none");
    private static final Component GENERAL_BUTTON = Component.translatable((String)"stat.generalButton");
    private static final Component ITEMS_BUTTON = Component.translatable((String)"stat.itemsButton");
    private static final Component MOBS_BUTTON = Component.translatable((String)"stat.mobsButton");
    private static final int LIST_WIDTH = 280;
    private static final int PADDING = 5;
    private static final int FOOTER_HEIGHT = 58;
    private HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 33, 58);
    @Nullable
    private GeneralStatisticsList statsList;
    @Nullable
    ItemStatisticsList itemStatsList;
    @Nullable
    private MobsStatisticsList mobsStatsList;
    final StatsCounter stats;
    @Nullable
    private ObjectSelectionList<?> activeList;
    private boolean isLoading = true;

    public StatSelectScreen(StatFrameBlockTile tile, StatsCounter stats) {
        super(null, stats);
        this.tile = tile;
        this.stats = stats;
    }

    protected void init() {
        this.layout.addToContents((LayoutElement)new LoadingDotsWidget(this.font, PENDING_TEXT));
        this.minecraft.getConnection().send((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
    }

    public void initLists() {
        this.statsList = new GeneralStatisticsList(this.minecraft);
        this.itemStatsList = new ItemStatisticsList(this.minecraft);
        this.mobsStatsList = new MobsStatisticsList(this.minecraft);
    }

    public void initButtons() {
        HeaderAndFooterLayout headerAndFooterLayout = new HeaderAndFooterLayout((Screen)this, 33, 58);
        headerAndFooterLayout.addTitleHeader(TITLE, this.font);
        LinearLayout linearLayout = ((LinearLayout)headerAndFooterLayout.addToFooter((LayoutElement)LinearLayout.vertical())).spacing(5);
        linearLayout.defaultCellSetting().alignHorizontallyCenter();
        LinearLayout linearLayout2 = ((LinearLayout)linearLayout.addChild((LayoutElement)LinearLayout.horizontal())).spacing(5);
        linearLayout2.addChild((LayoutElement)Button.builder((Component)GENERAL_BUTTON, buttonx -> this.setActiveList(this.statsList)).width(120).build());
        Button button = (Button)linearLayout2.addChild((LayoutElement)Button.builder((Component)ITEMS_BUTTON, buttonx -> this.setActiveList(this.itemStatsList)).width(120).build());
        Button button2 = (Button)linearLayout2.addChild((LayoutElement)Button.builder((Component)MOBS_BUTTON, buttonx -> this.setActiveList(this.mobsStatsList)).width(120).build());
        linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, buttonx -> this.onClose()).width(200).build());
        if (this.itemStatsList != null && this.itemStatsList.children().isEmpty()) {
            button.active = false;
        }
        if (this.mobsStatsList != null && this.mobsStatsList.children().isEmpty()) {
            button2.active = false;
        }
        this.layout = headerAndFooterLayout;
        this.layout.visitWidgets(guiEventListener -> {
            AbstractWidget var10000 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)guiEventListener);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.activeList != null) {
            this.activeList.updateSize(this.width, this.layout);
        }
    }

    public void onClose() {
        this.minecraft.setScreen(null);
    }

    public void onStatsUpdated() {
        if (this.isLoading) {
            this.initLists();
            this.setActiveList(this.statsList);
            this.initButtons();
            this.setInitialFocus();
            this.isLoading = false;
        }
    }

    public boolean isPauseScreen() {
        return !this.isLoading;
    }

    public void setActiveList(@Nullable ObjectSelectionList<?> activeList) {
        if (this.activeList != null) {
            this.removeWidget((GuiEventListener)this.activeList);
        }
        if (activeList != null) {
            this.addRenderableWidget((GuiEventListener)activeList);
            this.activeList = activeList;
            this.repositionElements();
        }
    }

    static String getTranslationKey(Stat<ResourceLocation> stat) {
        return "stat." + ((ResourceLocation)stat.getValue()).toString().replace(':', '.');
    }

    private <T> void selectStat(StatType<T> statType, T obj) {
        NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundSetStatFramePacket(this.tile.getBlockPos(), statType, obj));
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        this.onClose();
    }

    class GeneralStatisticsList
    extends ObjectSelectionList<Entry> {
        public GeneralStatisticsList(Minecraft minecraft) {
            super(minecraft, StatSelectScreen.this.width, StatSelectScreen.this.height - 33 - 58, 33, 14);
            ObjectArrayList objectArrayList = new ObjectArrayList(Stats.CUSTOM.iterator());
            objectArrayList.sort(Comparator.comparing(statx -> I18n.get((String)StatSelectScreen.getTranslationKey((Stat<ResourceLocation>)statx), (Object[])new Object[0])));
            for (Stat stat : objectArrayList) {
                this.addEntry((AbstractSelectionList.Entry)new Entry((Stat<ResourceLocation>)stat));
            }
        }

        public int getRowWidth() {
            return 280;
        }

        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final Stat<ResourceLocation> stat;
            private final Component statDisplay;

            Entry(Stat<ResourceLocation> stat) {
                this.stat = stat;
                this.statDisplay = Component.translatable((String)StatSelectScreen.getTranslationKey(stat));
            }

            private String getValueText() {
                return this.stat.format(StatSelectScreen.this.stats.getValue(this.stat));
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                int i = top + height / 2 - 4;
                int j = index % 2 == 0 ? -1 : -4539718;
                guiGraphics.drawString(StatSelectScreen.this.font, this.statDisplay, left + 2, i, j);
                String string = this.getValueText();
                guiGraphics.drawString(StatSelectScreen.this.font, string, left + width - StatSelectScreen.this.font.width(string) - 4, i, j);
                if (hovering) {
                    guiGraphics.fillGradient(RenderType.guiOverlay(), left, top, left + width, top + height + 2, -2130706433, -2130706433, 0);
                }
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select", (Object[])new Object[]{Component.empty().append(this.statDisplay).append(CommonComponents.SPACE).append(this.getValueText())});
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                StatSelectScreen.this.selectStat(this.stat.getType(), (ResourceLocation)this.stat.getValue());
                return false;
            }
        }
    }

    class ItemStatisticsList
    extends ObjectSelectionList<ItemRow> {
        private final ResourceLocation[] iconSprites;
        protected final List<StatType<Block>> blockColumns;
        protected final List<StatType<Item>> itemColumns;
        protected final Comparator<ItemRow> itemStatSorter;
        @Nullable
        protected StatType<?> sortColumn;
        protected int headerPressed;
        protected int sortOrder;

        public ItemStatisticsList(Minecraft minecraft) {
            boolean bl;
            super(minecraft, StatSelectScreen.this.width, StatSelectScreen.this.height - 33 - 58, 33, 22);
            this.iconSprites = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"statistics/block_mined"), ResourceLocation.withDefaultNamespace((String)"statistics/item_broken"), ResourceLocation.withDefaultNamespace((String)"statistics/item_crafted"), ResourceLocation.withDefaultNamespace((String)"statistics/item_used"), ResourceLocation.withDefaultNamespace((String)"statistics/item_picked_up"), ResourceLocation.withDefaultNamespace((String)"statistics/item_dropped")};
            this.itemStatSorter = new ItemRowComparator();
            this.headerPressed = -1;
            this.blockColumns = Lists.newArrayList();
            this.blockColumns.add((StatType<Block>)Stats.BLOCK_MINED);
            this.itemColumns = Lists.newArrayList((Object[])new StatType[]{Stats.ITEM_BROKEN, Stats.ITEM_CRAFTED, Stats.ITEM_USED, Stats.ITEM_PICKED_UP, Stats.ITEM_DROPPED});
            this.setRenderHeader(true, 22);
            Set set = Sets.newIdentityHashSet();
            for (Item item : BuiltInRegistries.ITEM) {
                bl = false;
                for (StatType<Item> statType : this.itemColumns) {
                    if (!statType.contains((Object)item) || StatSelectScreen.this.stats.getValue(statType.get((Object)item)) <= 0) continue;
                    bl = true;
                }
                if (!bl) continue;
                set.add(item);
            }
            for (Block block : BuiltInRegistries.BLOCK) {
                bl = false;
                for (StatType<Item> statType : this.blockColumns) {
                    if (!statType.contains((Object)block) || StatSelectScreen.this.stats.getValue(statType.get((Object)block)) <= 0) continue;
                    bl = true;
                }
                if (!bl) continue;
                set.add(block.asItem());
            }
            set.remove(Items.AIR);
            for (Item item : set) {
                this.addEntry((AbstractSelectionList.Entry)new ItemRow(item));
            }
        }

        int getColumnX(int index) {
            return 75 + 40 * index;
        }

        protected void renderHeader(GuiGraphics guiGraphics, int x, int y) {
            ResourceLocation resourceLocation;
            int i;
            if (!this.minecraft.mouseHandler.isLeftPressed()) {
                this.headerPressed = -1;
            }
            for (i = 0; i < this.iconSprites.length; ++i) {
                resourceLocation = this.headerPressed == i ? SLOT_SPRITE : HEADER_SPRITE;
                guiGraphics.blitSprite(resourceLocation, x + this.getColumnX(i) - 18, y + 1, 0, 18, 18);
            }
            if (this.sortColumn != null) {
                i = this.getColumnX(this.getColumnIndex(this.sortColumn)) - 36;
                resourceLocation = this.sortOrder == 1 ? SORT_UP_SPRITE : SORT_DOWN_SPRITE;
                guiGraphics.blitSprite(resourceLocation, x + i, y + 1, 0, 18, 18);
            }
            for (i = 0; i < this.iconSprites.length; ++i) {
                int j = this.headerPressed == i ? 1 : 0;
                guiGraphics.blitSprite(this.iconSprites[i], x + this.getColumnX(i) - 18 + j, y + 1 + j, 0, 18, 18);
            }
        }

        public int getRowWidth() {
            return 280;
        }

        protected boolean clickedHeader(int x, int y) {
            this.headerPressed = -1;
            for (int i = 0; i < this.iconSprites.length; ++i) {
                int j = x - this.getColumnX(i);
                if (j < -36 || j > 0) continue;
                this.headerPressed = i;
                break;
            }
            if (this.headerPressed >= 0) {
                this.sortByColumn(this.getColumn(this.headerPressed));
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return true;
            }
            return super.clickedHeader(x, y);
        }

        private StatType<?> getColumn(int index) {
            return index < this.blockColumns.size() ? this.blockColumns.get(index) : this.itemColumns.get(index - this.blockColumns.size());
        }

        private int getColumnIndex(StatType<?> statType) {
            int i = this.blockColumns.indexOf(statType);
            if (i >= 0) {
                return i;
            }
            int j = this.itemColumns.indexOf(statType);
            return j >= 0 ? j + this.blockColumns.size() : -1;
        }

        protected void renderDecorations(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (mouseY >= this.getY() && mouseY <= this.getBottom()) {
                ItemRow itemRow = (ItemRow)this.getHovered();
                int i = this.getRowLeft();
                if (itemRow != null) {
                    if (mouseX < i || mouseX > i + 18) {
                        return;
                    }
                    Item item = itemRow.getItem();
                    guiGraphics.renderTooltip(StatSelectScreen.this.font, item.getDescription(), mouseX, mouseY);
                } else {
                    Component component = null;
                    int j = mouseX - i;
                    for (int k = 0; k < this.iconSprites.length; ++k) {
                        int l = this.getColumnX(k);
                        if (j < l - 18 || j > l) continue;
                        component = this.getColumn(k).getDisplayName();
                        break;
                    }
                    if (component != null) {
                        guiGraphics.renderTooltip(StatSelectScreen.this.font, component, mouseX, mouseY);
                    }
                }
            }
        }

        protected void sortByColumn(StatType<?> statType) {
            if (statType != this.sortColumn) {
                this.sortColumn = statType;
                this.sortOrder = -1;
            } else if (this.sortOrder == -1) {
                this.sortOrder = 1;
            } else {
                this.sortColumn = null;
                this.sortOrder = 0;
            }
            this.children().sort(this.itemStatSorter);
        }

        class ItemRowComparator
        implements Comparator<ItemRow> {
            ItemRowComparator() {
            }

            @Override
            public int compare(ItemRow row1, ItemRow row2) {
                int j;
                int i;
                Item item = row1.getItem();
                Item item2 = row2.getItem();
                if (ItemStatisticsList.this.sortColumn == null) {
                    i = 0;
                    j = 0;
                } else if (ItemStatisticsList.this.blockColumns.contains(ItemStatisticsList.this.sortColumn)) {
                    StatType<?> statType = ItemStatisticsList.this.sortColumn;
                    i = item instanceof BlockItem ? StatSelectScreen.this.stats.getValue(statType, (Object)((BlockItem)item).getBlock()) : -1;
                    j = item2 instanceof BlockItem ? StatSelectScreen.this.stats.getValue(statType, (Object)((BlockItem)item2).getBlock()) : -1;
                } else {
                    StatType<?> statType = ItemStatisticsList.this.sortColumn;
                    i = StatSelectScreen.this.stats.getValue(statType, (Object)item);
                    j = StatSelectScreen.this.stats.getValue(statType, (Object)item2);
                }
                return i == j ? ItemStatisticsList.this.sortOrder * Integer.compare(Item.getId((Item)item), Item.getId((Item)item2)) : ItemStatisticsList.this.sortOrder * Integer.compare(i, j);
            }
        }

        class ItemRow
        extends ObjectSelectionList.Entry<ItemRow> {
            private final Item item;
            private Stat<?> hovered = null;

            ItemRow(Item item) {
                this.item = item;
            }

            public Item getItem() {
                return this.item;
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                guiGraphics.blitSprite(SLOT_SPRITE, left, top, 0, 18, 18);
                guiGraphics.renderFakeItem(this.item.getDefaultInstance(), left + 1, top + 1);
                this.hovered = null;
                if (StatSelectScreen.this.itemStatsList != null) {
                    int i;
                    for (i = 0; i < StatSelectScreen.this.itemStatsList.blockColumns.size(); ++i) {
                        Stat stat;
                        Item item = this.item;
                        if (item instanceof BlockItem) {
                            BlockItem blockItem = (BlockItem)item;
                            stat = StatSelectScreen.this.itemStatsList.blockColumns.get(i).get((Object)blockItem.getBlock());
                        } else {
                            stat = null;
                        }
                        this.renderStat(guiGraphics, stat, left + ItemStatisticsList.this.getColumnX(i), top + height / 2 - 4, index % 2 == 0, hovering, mouseX);
                    }
                    for (i = 0; i < StatSelectScreen.this.itemStatsList.itemColumns.size(); ++i) {
                        this.renderStat(guiGraphics, StatSelectScreen.this.itemStatsList.itemColumns.get(i).get((Object)this.item), left + ItemStatisticsList.this.getColumnX(i + StatSelectScreen.this.itemStatsList.blockColumns.size()), top + height / 2 - 4, index % 2 == 0, hovering, mouseX);
                    }
                }
            }

            protected void renderStat(GuiGraphics guiGraphics, @Nullable Stat<?> stat, int x, int y, boolean odd, boolean isMouseOver, int mouseX) {
                String string = stat == null ? "-" : stat.format(StatSelectScreen.this.stats.getValue(stat));
                guiGraphics.drawString(StatSelectScreen.this.font, string, x - StatSelectScreen.this.font.width(string), y + 5, odd ? 0xFFFFFF : 0x909090);
                int w = 18;
                if (stat != null && isMouseOver && mouseX >= x - w && mouseX < x) {
                    guiGraphics.fillGradient(RenderType.guiOverlay(), x - w, y, x, y + w, -2130706433, -2130706433, 0);
                    this.hovered = stat;
                }
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.item.getDescription()});
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.hovered != null) {
                    StatType type = this.hovered.getType();
                    if (type.getRegistry() == BuiltInRegistries.BLOCK) {
                        StatSelectScreen.this.selectStat(type, ((BlockItem)this.item).getBlock());
                    } else {
                        StatSelectScreen.this.selectStat(type, this.item);
                    }
                }
                return false;
            }
        }
    }

    class MobsStatisticsList
    extends ObjectSelectionList<MobRow> {
        public MobsStatisticsList(Minecraft minecraft) {
            super(minecraft, StatSelectScreen.this.width, StatSelectScreen.this.height - 33 - 58, 33, 36);
            for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
                if (StatSelectScreen.this.stats.getValue(Stats.ENTITY_KILLED.get((Object)entityType)) <= 0 && StatSelectScreen.this.stats.getValue(Stats.ENTITY_KILLED_BY.get((Object)entityType)) <= 0) continue;
                this.addEntry((AbstractSelectionList.Entry)new MobRow(entityType));
            }
        }

        public int getRowWidth() {
            return 280;
        }

        class MobRow
        extends ObjectSelectionList.Entry<MobRow> {
            private final Component mobName;
            private final Component kills;
            private final Component killedBy;
            private final boolean hasKills;
            private final boolean wasKilledBy;
            private final EntityType<?> entity;
            private int hovered = 0;

            public MobRow(EntityType<?> entityType) {
                this.mobName = entityType.getDescription();
                this.entity = entityType;
                int i = StatSelectScreen.this.stats.getValue(Stats.ENTITY_KILLED.get(entityType));
                if (i == 0) {
                    this.kills = Component.translatable((String)"stat_type.minecraft.killed.none", (Object[])new Object[]{this.mobName});
                    this.hasKills = false;
                } else {
                    this.kills = Component.translatable((String)"stat_type.minecraft.killed", (Object[])new Object[]{i, this.mobName});
                    this.hasKills = true;
                }
                int j = StatSelectScreen.this.stats.getValue(Stats.ENTITY_KILLED_BY.get(entityType));
                if (j == 0) {
                    this.killedBy = Component.translatable((String)"stat_type.minecraft.killed_by.none", (Object[])new Object[]{this.mobName});
                    this.wasKilledBy = false;
                } else {
                    this.killedBy = Component.translatable((String)"stat_type.minecraft.killed_by", (Object[])new Object[]{this.mobName, j});
                    this.wasKilledBy = true;
                }
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
                this.hovered = 0;
                guiGraphics.drawString(StatSelectScreen.this.font, this.mobName, left + 2, top + 1, 0xFFFFFF);
                int stringX = left + 2 + 10;
                int stringY = top + 1 + 10;
                guiGraphics.drawString(StatSelectScreen.this.font, this.kills, stringX, stringY, this.hasKills ? 0x909090 : 0x606060);
                if (mouseY >= stringY && mouseY <= stringY + 9) {
                    this.hovered = 1;
                    guiGraphics.fillGradient(RenderType.guiOverlay(), stringX, stringY, left + width - 12, stringY + 9, -2130706433, -2130706433, 0);
                }
                stringY = top + 1 + 20;
                guiGraphics.drawString(StatSelectScreen.this.font, this.killedBy, stringX, stringY, this.wasKilledBy ? 0x909090 : 0x606060);
                if (mouseY >= stringY && mouseY <= stringY + 9) {
                    this.hovered = 2;
                    guiGraphics.fillGradient(RenderType.guiOverlay(), stringX, stringY, left + width - 12, stringY + 9, -2130706433, -2130706433, 0);
                }
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select", (Object[])new Object[]{CommonComponents.joinForNarration((Component[])new Component[]{this.kills, this.killedBy})});
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.hovered == 1) {
                    StatSelectScreen.this.selectStat(Stats.ENTITY_KILLED, this.entity);
                } else if (this.hovered == 2) {
                    StatSelectScreen.this.selectStat(Stats.ENTITY_KILLED_BY, this.entity);
                }
                return false;
            }
        }
    }
}

