/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlock;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlock;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlockTile;
import net.mehvahdjukaar.advframes.client.BaseFrameTileRenderer;
import net.mehvahdjukaar.advframes.client.ClientConfigs;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.stats.Stat;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class StatFrameBlockTileRenderer
extends BaseFrameTileRenderer<StatFrameBlockTile> {
    private static final float PAPER_Y_MARGIN = 0.40625f;
    private static final float PAPER_X_MARGIN = 0.125f;

    public StatFrameBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(StatFrameBlockTile tile, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int packedOverlay) {
        Stat<?> stat = tile.getStat();
        if (stat != null) {
            float dx;
            Direction dir = (Direction)tile.getBlockState().getValue((Property)StatFrameBlock.FACING);
            float yaw = -dir.toYRot();
            Vec3 cameraPos = this.camera.getPosition();
            BlockPos pos = tile.getBlockPos();
            LOD lod = new LOD(cameraPos, pos);
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(RotHlpr.rot((Direction)((Direction)tile.getBlockState().getValue((Property)AdvancementFrameBlock.FACING)).getOpposite()));
            double z = -0.4275;
            poseStack.translate(0.0, 0.0, z);
            poseStack.pushPose();
            poseStack.translate(0.0, 0.6875, -0.03025);
            TextUtil.RenderProperties textProperties = this.computeRenderProperties(light, dir.step(), () -> ((LOD)lod).isVeryNear());
            if (tile.needsVisualUpdate()) {
                this.updateAndCacheLines(tile, stat, textProperties);
            }
            List<FormattedCharSequence> rendererLines = tile.getCachedLines();
            float scale = tile.getFontScale();
            poseStack.scale(scale, -scale, scale);
            int numberOfLines = rendererLines.size();
            boolean centered = ClientConfigs.CENTERED_TEXT.get();
            for (int lin = 0; lin < numberOfLines; ++lin) {
                FormattedCharSequence str = rendererLines.get(lin);
                dx = centered ? (float)(-this.font.width(str)) / 2.0f + 0.5f : -0.375f / scale;
                float dy = (1.0f / scale - (float)(8 * numberOfLines)) / 2.0f + 0.5f;
                Matrix4f pose = poseStack.last().pose();
                this.font.drawInBatch(str, dx, dy + (float)(8 * lin), textProperties.darkenedColor(), false, pose, buffer, Font.DisplayMode.NORMAL, 0, textProperties.light());
            }
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(0.0, 0.5625, -0.03025);
            float valueScale = 0.015625f;
            poseStack.scale(valueScale, -valueScale, valueScale);
            String number = stat.format(tile.getValue());
            dx = centered ? (float)(-this.font.width(number)) / 2.0f + 0.5f : -0.375f / scale;
            MutableComponent c = Component.literal((String)number).withStyle(ChatFormatting.DARK_RED);
            this.font.drawInBatch((Component)c, dx, 40.0f, textProperties.darkenedColor(), true, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, textProperties.light());
            poseStack.popPose();
            this.renderTopTextBottomText(lod, tile, poseStack, buffer, light, 0.3125f);
            poseStack.popPose();
        }
    }

    private void updateAndCacheLines(StatFrameBlockTile tile, Stat<?> stat, TextUtil.RenderProperties textProperties) {
        float paperWidth = 0.75f;
        float paperHeight = 0.1875f;
        MutableComponent text = StatFrameBlock.getStatComponent(stat);
        text = text.setStyle(textProperties.style());
        Pair p = TextUtil.fitLinesToBox((Font)this.font, (FormattedText)text, (float)paperWidth, (float)paperHeight);
        tile.setFontScale(((Float)p.getSecond()).floatValue());
        tile.setCachedPageLines((List)p.getFirst());
    }

    public TextUtil.RenderProperties computeRenderProperties(int combinedLight, Vector3f normal, BooleanSupplier shouldShowGlow) {
        return TextUtil.renderProperties((DyeColor)DyeColor.BLACK, (boolean)false, (float)ClientConfigs.getSignColorMult(), (int)combinedLight, (Style)Style.EMPTY, (Vector3f)normal, (BooleanSupplier)shouldShowGlow);
    }
}

