/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.advframes.blocks.BaseFrameBlockTile;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;

public abstract class BaseFrameTileRenderer<T extends BaseFrameBlockTile>
implements BlockEntityRenderer<T> {
    protected final ItemRenderer itemRenderer;
    protected final EntityRenderDispatcher entityRenderer;
    protected final Font font;
    protected final Minecraft minecraft = Minecraft.getInstance();
    protected final Camera camera;

    protected BaseFrameTileRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = this.minecraft.getItemRenderer();
        this.entityRenderer = this.minecraft.getEntityRenderDispatcher();
        this.font = this.minecraft.font;
        this.camera = this.minecraft.gameRenderer.getMainCamera();
    }

    public void renderTopTextBottomText(LOD lod, T tile, PoseStack poseStack, MultiBufferSource buffer, int light, float offset) {
        BlockPos hitPos;
        BlockPos pos;
        HitResult hit;
        if (Minecraft.renderNames() && lod.isVeryNear() && (hit = this.minecraft.hitResult) != null && hit.getType() == HitResult.Type.BLOCK && (pos = tile.getBlockPos()).equals((Object)(hitPos = BlockPos.containing((Position)hit.getLocation())))) {
            Component name;
            Component title = ((BaseFrameBlockTile)((Object)tile)).getTitle();
            int opacity = 0;
            if (title != null) {
                poseStack.pushPose();
                float width = this.font.width((FormattedText)title);
                float scale = 0.025f;
                if (width > 48.0f) {
                    scale /= width / 48.0f;
                }
                poseStack.translate(0.0, (double)(offset + 4.0f * scale), 0.0125);
                poseStack.scale(scale, -scale, scale);
                Matrix4f matrix4f = poseStack.last().pose();
                float dx = -width / 2.0f;
                this.font.drawInBatch(title, dx, 0.0f, ((BaseFrameBlockTile)((Object)tile)).getTitleColor().getColor().intValue(), true, matrix4f, buffer, Font.DisplayMode.POLYGON_OFFSET, opacity, light);
                poseStack.popPose();
            }
            if ((name = ((BaseFrameBlockTile)((Object)tile)).getOwnerName()) != null) {
                poseStack.pushPose();
                float width = this.font.width((FormattedText)name);
                float scale = 0.025f;
                if (width > 48.0f) {
                    scale /= width / 48.0f;
                }
                poseStack.translate(0.0, (double)(-offset + 4.0f * scale), 0.0125);
                poseStack.scale(scale, -scale, scale);
                Matrix4f matrix4f = poseStack.last().pose();
                float dx = -width / 2.0f;
                this.font.drawInBatch(name, dx, 0.0f, -1, true, matrix4f, buffer, Font.DisplayMode.POLYGON_OFFSET, opacity, light);
                poseStack.popPose();
            }
        }
    }
}

