/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.client;

import java.util.Objects;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlockTile;
import net.mehvahdjukaar.advframes.network.ServerBoundSetAdvancementFramePacket;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class AdvancementSelectScreen
extends AdvancementsScreen {
    private final AdvancementFrameBlockTile tile;
    private final MutableComponent title2;
    private static final ResourceLocation WINDOW_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/advancements/window.png");

    public AdvancementSelectScreen(AdvancementFrameBlockTile tile, ClientAdvancements clientAdvancements) {
        super(clientAdvancements);
        this.tile = tile;
        this.title2 = Component.translatable((String)"advancementframes.gui.advancements");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AdvancementSelectScreen that = (AdvancementSelectScreen)((Object)o);
        return Objects.equals((Object)this.tile, (Object)that.tile);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tile});
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        AdvancementTab tab;
        if (button == 0 && (tab = this.selectedTab) != null) {
            int oX = (this.width - 252) / 2;
            int oY = (this.height - 140) / 2;
            int x = (int)(mouseX - (double)oX - 9.0);
            int y = (int)(mouseY - (double)oY - 18.0);
            int scrollX = Mth.floor((double)tab.scrollX);
            int scrollY = Mth.floor((double)tab.scrollY);
            if (x > 0 && x < 234 && y > 0 && y < 113) {
                for (AdvancementWidget advancementwidget : tab.widgets.values()) {
                    if (!advancementwidget.isMouseOver(scrollX, scrollY, x, y)) continue;
                    AdvancementProgress p = advancementwidget.progress;
                    if (p == null || !p.isDone()) break;
                    NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundSetAdvancementFramePacket(this.tile.getBlockPos(), advancementwidget.advancementNode.holder()));
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    this.onClose();
                    return true;
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void renderWindow(GuiGraphics graphics, int x, int y) {
        super.renderWindow(graphics, x, y);
        graphics.blit(WINDOW_LOCATION, x, y + 5, 0, 5, 252, 11);
        float posX = (float)this.width / 2.0f - (float)this.font.width((FormattedText)this.title2) / 2.0f;
        graphics.drawString(this.font, (Component)this.title2, (int)posX, y + 6, 0x404040, false);
    }
}

