/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.client;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlock;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadsTransformer;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class AdvancementFrameModel
implements CustomBakedModel {
    private final BakedModel model;
    private final ModelState transform;

    public AdvancementFrameModel(BakedModel bakedModel, ModelState state) {
        this.model = bakedModel;
        this.transform = state;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        quads.addAll(this.model.getQuads(state, side, rand));
        Direction back = ((Direction)state.getValue((Property)AdvancementFrameBlock.FACING)).getOpposite();
        ModelResourceLocation model = ((AdvancementFrameBlock.Type)((Object)state.getValue(AdvancementFrameBlock.TYPE))).getModel();
        if (model != null) {
            Matrix4f matrix = this.transform.getRotation().getMatrix();
            matrix.rotateY((float)Math.PI);
            matrix.translate(0.0f, 0.0f, -0.46875f);
            BakedQuadsTransformer transformer = BakedQuadsTransformer.create().applyingTransform(matrix);
            BakedModel frame = ClientHelper.getModel((ModelManager)Minecraft.getInstance().getModelManager(), (ModelResourceLocation)model);
            quads.addAll(transformer.transformAll(frame.getQuads(state, side, rand)));
        }
        return quads;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        return this.model.getParticleIcon();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }
}

