/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlock;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlockTile;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlock;
import net.mehvahdjukaar.advframes.client.BaseFrameTileRenderer;
import net.mehvahdjukaar.advframes.client.ClientConfigs;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class AdvancementFrameBlockTileRenderer
extends BaseFrameTileRenderer<AdvancementFrameBlockTile> {
    public AdvancementFrameBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(AdvancementFrameBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        DisplayInfo advancement = tile.getAdvancement();
        if (advancement != null) {
            ResourceLocation tex;
            Direction dir = (Direction)tile.getBlockState().getValue((Property)StatFrameBlock.FACING);
            float yaw = -dir.toYRot();
            Vec3 cameraPos = this.camera.getPosition();
            BlockPos pos = tile.getBlockPos();
            LOD lod = new LOD(cameraPos, pos);
            ItemStack stack = advancement.getIcon();
            if (!ClientConfigs.ANIMATED_ICONS.get().booleanValue() && ItemStack.isSameItemSameComponents((ItemStack)stack.getItem().getDefaultInstance(), (ItemStack)stack)) {
                FrameBufferBackedDynamicTexture tt = RenderedTexturesManager.requestFlatItemTexture((Item)stack.getItem(), (int)64);
                tex = tt.getTextureLocation();
                if (!tt.isInitialized()) {
                    return;
                }
            } else {
                int i = Objects.hash(stack.getComponents(), stack.getItem());
                FrameBufferBackedDynamicTexture tt = RenderedTexturesManager.requestFlatItemStackTexture((ResourceLocation)AdvFrames.res("" + i), (ItemStack)stack, (int)64);
                tex = tt.getTextureLocation();
                if (!tt.isInitialized()) {
                    return;
                }
            }
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(RotHlpr.rot((Direction)((Direction)tile.getBlockState().getValue((Property)AdvancementFrameBlock.FACING)).getOpposite()));
            double z = -0.4275;
            poseStack.translate(0.0, 0.0, z);
            poseStack.pushPose();
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)tex));
            float s = 0.25f;
            int lu = light & 0xFFFF;
            int lv = light >> 16 & 0xFFFF;
            poseStack.scale(1.0f, -1.0f, -1.0f);
            VertexUtil.addQuad((VertexConsumer)vertexConsumer, (PoseStack)poseStack, (float)(-s), (float)(-s), (float)s, (float)s, (int)lu, (int)lv);
            poseStack.popPose();
            this.renderTopTextBottomText(lod, tile, poseStack, buffer, light, 0.375f);
            poseStack.popPose();
        }
    }
}

