/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.blocks.BaseFrameBlockTile;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class StatFrameBlockTile
extends BaseFrameBlockTile {
    @Nullable
    private Stat<?> stat = null;
    private int value = 0;
    private float fontScale = 1.0f;
    private List<FormattedCharSequence> cachedPageLines = Collections.emptyList();
    private boolean needsVisualRefresh = true;

    public StatFrameBlockTile(BlockPos pos, BlockState state) {
        super(AdvFrames.STAT_FRAME_TILE.get(), pos, state);
    }

    public <T> void setStat(StatType<T> stat, ResourceLocation objId, ServerPlayer player) {
        this.stat = stat.get(Objects.requireNonNull(stat.getRegistry().get(objId)));
        this.setOwner(new ResolvableProfile(player.getGameProfile()));
    }

    @Nullable
    public Stat<?> getStat() {
        return this.stat;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.stat != null) {
            tag.putString("Stat", BuiltInRegistries.STAT_TYPE.getKey((Object)this.stat.getType()).toString());
            tag.putString("StatKey", StatFrameBlockTile.getStatKey(this.stat).toString());
            tag.putInt("Value", this.value);
        }
    }

    private static <T> ResourceLocation getStatKey(Stat<T> stat) {
        return stat.getType().getRegistry().getKey(stat.getValue());
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.stat = null;
        if (tag.contains("Stat") && tag.contains("StatKey")) {
            ResourceLocation statValue = ResourceLocation.tryParse((String)tag.getString("StatKey"));
            StatType type = (StatType)BuiltInRegistries.STAT_TYPE.get(ResourceLocation.tryParse((String)tag.getString("Stat")));
            this.stat = this.getInstance(statValue, type);
            this.value = tag.getInt("Value");
        }
    }

    @Nullable
    private <T> Stat<T> getInstance(ResourceLocation id, StatType<T> type) {
        if (type == null) {
            return null;
        }
        Object value = type.getRegistry().get(id);
        if (value == null) {
            return null;
        }
        return type.get(value);
    }

    @Override
    @Nullable
    public Component getTitle() {
        return null;
    }

    @Override
    public ChatFormatting getTitleColor() {
        return ChatFormatting.WHITE;
    }

    @Override
    public boolean isEmpty() {
        return this.stat != null;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.stat != null) {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }
        return null;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StatFrameBlockTile tile) {
        if ((level.getGameTime() + 1L) % 100L == 0L) {
            tile.updateStatValue();
        }
    }

    public void updateStatValue() {
        ServerPlayer serverPlayer;
        ServerStatsCounter stats;
        int newValue;
        Player player;
        ResolvableProfile owner = this.getOwner();
        if (this.stat != null && owner != null && owner.id().isPresent() && (player = this.level.getPlayerByUUID((UUID)owner.id().get())) instanceof ServerPlayer && (newValue = (stats = (serverPlayer = (ServerPlayer)player).getStats()).getValue(this.stat)) != this.value) {
            this.value = newValue;
            this.setChanged();
            BlockState state = this.getBlockState();
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)StatFrameBlock.TRIGGERED, (Comparable)Boolean.valueOf(true)));
            this.level.scheduleTick(this.worldPosition, state.getBlock(), 2);
        }
    }

    public boolean needsVisualUpdate() {
        if (this.needsVisualRefresh) {
            this.needsVisualRefresh = false;
            return true;
        }
        return false;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float s) {
        this.fontScale = s;
    }

    public void setCachedPageLines(List<FormattedCharSequence> l) {
        this.cachedPageLines = l;
    }

    public List<FormattedCharSequence> getCachedLines() {
        return this.cachedPageLines;
    }

    public int getValue() {
        return this.value;
    }
}

