/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.AdvFramesClient;
import net.mehvahdjukaar.advframes.blocks.BaseFrameBlock;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlockTile;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StatFrameBlock
extends BaseFrameBlock {
    protected static final VoxelShape SHAPE_DOWN = Block.box((double)0.0, (double)15.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_UP = Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)1.0, (double)14.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)1.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;

    public StatFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TRIGGERED});
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)TRIGGERED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.cycle((Property)TRIGGERED), 2);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return null;
        }
        return Utils.getTicker(blockEntityType, AdvFrames.STAT_FRAME_TILE.get(), StatFrameBlockTile::tick);
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext p_60558_) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.UP -> SHAPE_UP;
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof StatFrameBlockTile) {
            StatFrameBlockTile tile = (StatFrameBlockTile)blockEntity;
            if (tile.getStat() == null) {
                AdvFramesClient.setStatScreen(tile, player);
            } else {
                ResolvableProfile owner = tile.getOwner();
                if (owner != null && owner.isResolved()) {
                    Stat<?> stat = tile.getStat();
                    MutableComponent name = tile.getOwnerName().copy().withStyle(ChatFormatting.GOLD);
                    MutableComponent title = StatFrameBlock.getStatComponent(stat);
                    MutableComponent number = Component.literal((String)stat.format(tile.getValue())).withStyle(ChatFormatting.DARK_RED);
                    player.displayClientMessage((Component)Component.translatable((String)"advancementframes.message.stat", (Object[])new Object[]{title, name, number}), true);
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StatFrameBlockTile(pos, state);
    }

    public static MutableComponent getStatComponent(Stat<?> stat) {
        StatType type = stat.getType();
        Object value = stat.getValue();
        ResourceLocation statId = BuiltInRegistries.STAT_TYPE.getKey((Object)type);
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemLike.class, EntityType.class, ResourceLocation.class}, (Object)object2, n)) {
            case 0 -> {
                ItemLike i = (ItemLike)object2;
                yield Component.translatable((String)("stat.advancementframes." + statId.getPath()), (Object[])new Object[]{i.asItem().getDescription().getString()});
            }
            case 1 -> {
                EntityType e = (EntityType)object2;
                yield Component.translatable((String)("stat.advancementframes." + statId.getPath()), (Object[])new Object[]{e.getDescription().getString()});
            }
            case 2 -> {
                ResourceLocation resourceLocation = (ResourceLocation)object2;
                String string = stat.getValue().toString();
                yield Component.translatable((String)("stat." + string.replace(':', '.')));
            }
            default -> Component.literal((String)"Unsupported Stat");
        };
    }
}

