/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFrameBlockTile
extends BlockEntity {
    protected ResolvableProfile owner;

    protected BaseFrameBlockTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.owner != null) {
            tag.put("profile", (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.owner).getOrThrow());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("PlayerID")) {
            UUID id = tag.getUUID("PlayerID");
            this.setOwner(new ResolvableProfile(Optional.empty(), Optional.of(id), new PropertyMap()));
        }
        if (tag.contains("profile")) {
            ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("profile")).resultOrPartial(string -> AdvFrames.LOGGER.error("Failed to load profile from player head: {}", string)).ifPresent(this::setOwner);
        }
    }

    public ResolvableProfile getOwner() {
        return this.owner;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable ResolvableProfile owner) {
        BaseFrameBlockTile baseFrameBlockTile = this;
        synchronized (baseFrameBlockTile) {
            this.owner = owner;
        }
        if (this.owner != null && !this.owner.isResolved()) {
            this.owner.resolve().thenAcceptAsync(resolvableProfile -> {
                this.owner = resolvableProfile;
                this.setChanged();
            }, SkullBlockEntity.CHECKED_MAIN_THREAD_EXECUTOR);
        } else {
            this.setChanged();
        }
    }

    @Nullable
    public Component getOwnerName() {
        if (this.owner != null) {
            return this.owner.name().map(Component::literal).orElse(null);
        }
        return null;
    }

    @Nullable
    public abstract Component getTitle();

    public abstract ChatFormatting getTitleColor();

    public abstract boolean isEmpty();
}

