/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlock;
import net.mehvahdjukaar.advframes.blocks.BaseFrameBlockTile;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameBlockTile
extends BaseFrameBlockTile {
    @Nullable
    private ResourceLocation advancementId = null;
    @Nullable
    private DisplayInfo advancementDisplay = null;

    public AdvancementFrameBlockTile(BlockPos pos, BlockState state) {
        super(AdvFrames.ADVANCEMENT_FRAME_TILE.get(), pos, state);
    }

    public void setAdvancement(AdvancementHolder advancement, ServerPlayer player) {
        this.advancementDisplay = advancement.value().display().orElse(null);
        this.advancementId = advancement.id();
        this.setOwner(new ResolvableProfile(player.getGameProfile()));
    }

    @Override
    protected void saveAdditional(CompoundTag cmp, HolderLookup.Provider registries) {
        super.saveAdditional(cmp, registries);
        if (this.advancementDisplay != null) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                if (this.owner != null && this.advancementId != null && this.owner.isResolved()) {
                    ServerPlayer sp;
                    AdvancementHolder advancement = server.getServer().getAdvancements().get(this.advancementId);
                    Player player = this.level.getPlayerByUUID((UUID)this.owner.id().get());
                    if (advancement == null || player instanceof ServerPlayer && !(sp = (ServerPlayer)player).getAdvancements().getOrStartProgress(advancement).isDone()) {
                        return;
                    }
                }
            }
            cmp.put("Advancement", (Tag)DisplayInfo.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.advancementDisplay).getOrThrow());
        }
    }

    @Override
    protected void loadAdditional(CompoundTag cmp, HolderLookup.Provider registries) {
        super.loadAdditional(cmp, registries);
        this.advancementId = null;
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        DisplayInfo.CODEC.parse((DynamicOps)ops, (Object)cmp.getCompound("Advancement")).ifSuccess(a -> {
            this.advancementDisplay = a;
        });
        if (this.level != null) {
            AdvancementFrameBlock.Type t = AdvancementFrameBlock.Type.get(this.advancementDisplay);
            if (this.getBlockState().getValue(AdvancementFrameBlock.TYPE) != t) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(AdvancementFrameBlock.TYPE, (Comparable)((Object)t)));
            }
        }
    }

    @Override
    public ChatFormatting getTitleColor() {
        AdvancementType v = this.getAdvancement().getType();
        if (v == AdvancementType.GOAL) {
            return ChatFormatting.AQUA;
        }
        return v.getChatColor();
    }

    @Override
    public boolean isEmpty() {
        return this.advancementDisplay != null;
    }

    @Nullable
    public DisplayInfo getAdvancement() {
        return this.advancementDisplay;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.advancementDisplay != null) {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }
        return null;
    }

    @Override
    @Nullable
    public Component getTitle() {
        if (this.advancementDisplay != null) {
            return this.advancementDisplay.getTitle();
        }
        return null;
    }
}

