/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import java.util.Locale;
import net.mehvahdjukaar.advframes.AdvFramesClient;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlockTile;
import net.mehvahdjukaar.advframes.blocks.BaseFrameBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameBlock
extends BaseFrameBlock {
    protected static final VoxelShape SHAPE_DOWN = Block.box((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SHAPE_UP = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"frame_type", Type.class);

    public AdvancementFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(TYPE, (Comparable)((Object)Type.NONE)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext p_60558_) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.UP -> SHAPE_UP;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof AdvancementFrameBlockTile) {
            AdvancementFrameBlockTile tile = (AdvancementFrameBlockTile)blockEntity;
            if (tile.getAdvancement() == null) {
                AdvFramesClient.setAdvancementScreen(tile, player);
            } else {
                Component ownerName = tile.getOwnerName();
                if (ownerName != null) {
                    DisplayInfo advancement = tile.getAdvancement();
                    if (player.isSecondaryUseActive()) {
                        player.displayClientMessage(advancement.getDescription(), true);
                    } else {
                        MutableComponent name = ownerName.copy().withStyle(ChatFormatting.GOLD);
                        MutableComponent title = Component.literal((String)advancement.getTitle().getString()).withStyle(tile.getTitleColor());
                        player.displayClientMessage((Component)Component.translatable((String)"advancementframes.message.advancement", (Object[])new Object[]{name, title}), true);
                    }
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AdvancementFrameBlockTile(pos, state);
    }

    public static enum Type implements StringRepresentable
    {
        TASK,
        CHALLENGE,
        GOAL,
        NONE;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static Type get(@Nullable DisplayInfo type) {
            if (type == null) {
                return NONE;
            }
            return Type.values()[type.getType().ordinal()];
        }

        @OnlyIn(value=Dist.CLIENT)
        @Nullable
        public ModelResourceLocation getModel() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> AdvFramesClient.GOAL_MODEL;
                case 0 -> AdvFramesClient.TASK_MODEL;
                case 1 -> AdvFramesClient.CHALLENGE_MODEL;
                case 3 -> null;
            };
        }
    }
}

