/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes;

import com.mojang.blaze3d.vertex.BufferUploader;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlockTile;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlockTile;
import net.mehvahdjukaar.advframes.client.AdvancementFrameBlockTileRenderer;
import net.mehvahdjukaar.advframes.client.AdvancementFrameModel;
import net.mehvahdjukaar.advframes.client.AdvancementSelectScreen;
import net.mehvahdjukaar.advframes.client.ClientConfigs;
import net.mehvahdjukaar.advframes.client.StatFrameBlockTileRenderer;
import net.mehvahdjukaar.advframes.client.StatSelectScreen;
import net.mehvahdjukaar.advframes.integration.CreateCompat;
import net.mehvahdjukaar.advframes.neoforge.AdvFramesClientImpl;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.client.model.NestedModelLoader;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class AdvFramesClient {
    public static final ModelResourceLocation TASK_MODEL = RenderUtil.getStandaloneModelLocation((ResourceLocation)AdvFrames.res("item/task"));
    public static final ModelResourceLocation GOAL_MODEL = RenderUtil.getStandaloneModelLocation((ResourceLocation)AdvFrames.res("item/goal"));
    public static final ModelResourceLocation CHALLENGE_MODEL = RenderUtil.getStandaloneModelLocation((ResourceLocation)AdvFrames.res("item/challenge"));
    protected static long gameTime;

    public static void init() {
        ClientConfigs.init();
        ClientHelper.addSpecialModelRegistration(AdvFramesClient::registerSpecialModels);
        ClientHelper.addBlockEntityRenderersRegistration(AdvFramesClient::registerBlockEntityRenderers);
        ClientHelper.addModelLoaderRegistration(AdvFramesClient::registerModelLoaders);
        ClientHelper.addClientSetup(AdvFramesClient::clientSetup);
    }

    public static void clientSetup() {
        if (PlatHelper.isModLoaded((String)"create")) {
            CreateCompat.setupClient();
        }
        ClientHelper.registerRenderType((Block)AdvFrames.ADVANCEMENT_FRAME.get(), (RenderType)RenderType.cutout());
    }

    private static void registerModelLoaders(ClientHelper.ModelLoaderEvent event) {
        event.register(AdvFrames.res("advancement_frame"), (CustomModelLoader)new NestedModelLoader("frame", AdvancementFrameModel::new));
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        event.register(AdvFrames.ADVANCEMENT_FRAME_TILE.get(), AdvancementFrameBlockTileRenderer::new);
        event.register(AdvFrames.STAT_FRAME_TILE.get(), StatFrameBlockTileRenderer::new);
    }

    private static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        event.register(TASK_MODEL);
        event.register(GOAL_MODEL);
        event.register(CHALLENGE_MODEL);
    }

    public static void setStatScreen(StatFrameBlockTile tile, Player player) {
        if (player instanceof LocalPlayer) {
            LocalPlayer lp = (LocalPlayer)player;
            Minecraft minecraft = Minecraft.getInstance();
            StatSelectScreen screen = new StatSelectScreen(tile, lp.getStats());
            minecraft.setScreen((Screen)screen);
        }
    }

    public static void setAdvancementScreen(AdvancementFrameBlockTile tile, Player player) {
        if (player instanceof LocalPlayer) {
            LocalPlayer lp = (LocalPlayer)player;
            Minecraft minecraft = Minecraft.getInstance();
            AdvancementSelectScreen screen = new AdvancementSelectScreen(tile, lp.connection.getAdvancements());
            AdvFramesClient.clearForgeGuiLayers(minecraft);
            Screen old = minecraft.screen;
            if (old != null) {
                old.removed();
            }
            minecraft.screen = screen;
            BufferUploader.reset();
            minecraft.mouseHandler.releaseMouse();
            KeyMapping.releaseAll();
            screen.init(minecraft, minecraft.getWindow().getGuiScaledWidth(), minecraft.getWindow().getGuiScaledHeight());
            minecraft.noRender = false;
            minecraft.updateTitle();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void clearForgeGuiLayers(Minecraft minecraft) {
        AdvFramesClientImpl.clearForgeGuiLayers(minecraft);
    }

    public static void updatePlayerStats(Object2IntMap<Stat<?>> stats) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            for (Object2IntMap.Entry entry : stats.object2IntEntrySet()) {
                Stat stat = (Stat)entry.getKey();
                int i = entry.getIntValue();
                player.getStats().setValue((Player)Minecraft.getInstance().player, stat, i);
            }
        }
    }
}

