/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes;

import java.util.function.Supplier;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlock;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlockTile;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlock;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlockTile;
import net.mehvahdjukaar.advframes.integration.CreateCompat;
import net.mehvahdjukaar.advframes.network.ModMessages;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvFrames {
    public static final String MOD_ID = "advancementframes";
    public static final Logger LOGGER = LogManager.getLogger((String)"Advancement Frames");
    public static final ResourceLocation ADVANCEMENT_FRAME_NAME = AdvFrames.res("advancement_frame");
    public static final Supplier<Block> ADVANCEMENT_FRAME = RegHelper.registerBlock((ResourceLocation)ADVANCEMENT_FRAME_NAME, () -> new AdvancementFrameBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).mapColor(MapColor.NONE).sound(SoundType.WOOD).strength(0.25f, 0.25f).noCollission()));
    public static final Supplier<Item> ADVANCEMENT_FRAME_ITEM = RegHelper.registerItem((ResourceLocation)ADVANCEMENT_FRAME_NAME, () -> new BlockItem(ADVANCEMENT_FRAME.get(), new Item.Properties()));
    public static final Supplier<BlockEntityType<AdvancementFrameBlockTile>> ADVANCEMENT_FRAME_TILE = RegHelper.registerBlockEntityType((ResourceLocation)ADVANCEMENT_FRAME_NAME, () -> PlatHelper.newBlockEntityType(AdvancementFrameBlockTile::new, (Block[])new Block[]{ADVANCEMENT_FRAME.get()}));
    public static final ResourceLocation STAT_FRAME_NAME = AdvFrames.res("stat_frame");
    public static final Supplier<Block> STAT_FRAME = RegHelper.registerBlock((ResourceLocation)STAT_FRAME_NAME, () -> new StatFrameBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ADVANCEMENT_FRAME.get()))));
    public static final Supplier<Item> ASTAT_FRAME_ITEM = RegHelper.registerItem((ResourceLocation)STAT_FRAME_NAME, () -> new BlockItem(STAT_FRAME.get(), new Item.Properties()));
    public static final Supplier<BlockEntityType<StatFrameBlockTile>> STAT_FRAME_TILE = RegHelper.registerBlockEntityType((ResourceLocation)STAT_FRAME_NAME, () -> PlatHelper.newBlockEntityType(StatFrameBlockTile::new, (Block[])new Block[]{STAT_FRAME.get()}));

    public static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        ModMessages.init();
        RegHelper.addItemsToTabsRegistration(AdvFrames::addCreativeTabItems);
        PlatHelper.addCommonSetup(AdvFrames::commonSetup);
        if (PlatHelper.isModLoaded((String)"create")) {
            CreateCompat.init();
        }
    }

    public static void commonSetup() {
        if (PlatHelper.isModLoaded((String)"create")) {
            CreateCompat.setup();
        }
    }

    private static void addCreativeTabItems(RegHelper.ItemToTabEvent event) {
        event.addBefore(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> i.is(Items.ITEM_FRAME), new ItemLike[]{(ItemLike)ADVANCEMENT_FRAME_ITEM.get(), (ItemLike)ASTAT_FRAME_ITEM.get()});
    }
}

