/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.betterdungeons.module.StructurePieceTypeModule;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonPiece;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import java.util.BitSet;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.Fluids;

@ParametersAreNonnullByDefault
public class SpiderDungeonNestPiece
extends SpiderDungeonPiece {
    private final BlockPos startPos;
    private float xRadius = 0.0f;
    private float yRadius = 0.0f;
    private float zRadius = 0.0f;
    private static final float X_MINRADIUS = 6.0f;
    private static final float X_MAXRADIUS = 10.0f;
    private static final float Y_MINRADIUS = 4.0f;
    private static final float Y_MAXRADIUS = 6.0f;
    private static final float Z_MINRADIUS = 6.0f;
    private static final float Z_MAXRADIUS = 10.0f;
    private static final BlockStateRandomizer COBWEB_SELECTOR = BlockStateRandomizer.from((BlockState[])new BlockState[]{Blocks.COBWEB.defaultBlockState()});
    private static final BlockStateRandomizer WOOL_SELECTOR = BlockStateRandomizer.from((BlockState[])new BlockState[]{Blocks.WHITE_WOOL.defaultBlockState()});

    public SpiderDungeonNestPiece(BlockPos startPos, int pieceChainLength) {
        super(StructurePieceTypeModule.NEST, pieceChainLength, SpiderDungeonNestPiece.getInitialBoundingBox(startPos));
        this.startPos = new BlockPos(startPos.getX(), startPos.getY(), startPos.getZ());
    }

    public SpiderDungeonNestPiece(CompoundTag compoundTag) {
        super(StructurePieceTypeModule.NEST, compoundTag);
        int[] start = compoundTag.getIntArray("startPos");
        this.startPos = new BlockPos(start[0], start[1], start[2]);
        this.xRadius = compoundTag.getFloat("xRadius");
        this.yRadius = compoundTag.getFloat("yRadius");
        this.zRadius = compoundTag.getFloat("zRadius");
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        compoundTag.putIntArray("startPos", new int[]{this.startPos.getX(), this.startPos.getY(), this.startPos.getZ()});
        compoundTag.putFloat("xRadius", this.xRadius);
        compoundTag.putFloat("yRadius", this.yRadius);
        compoundTag.putFloat("zRadius", this.zRadius);
    }

    public void addChildren(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, RandomSource randomSource) {
        this.xRadius = randomSource.nextFloat() * 4.0f + 6.0f;
        this.yRadius = randomSource.nextFloat() * 2.0f + 4.0f;
        this.zRadius = randomSource.nextFloat() * 4.0f + 6.0f;
        ((BoundingBoxAccessor)this.boundingBox).setMinX(this.startPos.getX() - (int)this.xRadius - 4);
        ((BoundingBoxAccessor)this.boundingBox).setMaxX(this.startPos.getX() + (int)this.xRadius + 4);
        ((BoundingBoxAccessor)this.boundingBox).setMinY(this.startPos.getY() - (int)this.yRadius - 4);
        ((BoundingBoxAccessor)this.boundingBox).setMaxY(this.startPos.getY() + (int)this.yRadius + 4);
        ((BoundingBoxAccessor)this.boundingBox).setMinZ(this.startPos.getZ() - (int)this.zRadius - 4);
        ((BoundingBoxAccessor)this.boundingBox).setMaxZ(this.startPos.getZ() + (int)this.zRadius + 4);
    }

    public void postProcess(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        WorldgenRandom decoRand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        decoRand.setLargeFeatureSeed(world.getSeed(), this.startPos.getX(), this.startPos.getZ());
        int xBits = 4;
        int zBits = 4;
        int yBits = Mth.ceillog2((int)(world.getMaxBuildHeight() - world.getMinBuildHeight()));
        BitSet carvingMask = new BitSet((int)Math.pow(2.0, xBits + zBits + yBits));
        BlockStateRandomizer shellSelector = new BlockStateRandomizer(Blocks.COBBLESTONE.defaultBlockState());
        int[] surface = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.set(chunkPos.getMinBlockX() + x, 1, chunkPos.getMinBlockZ() + z);
                surface[x * 16 + z] = world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, mutable.getX(), mutable.getZ());
            }
        }
        float caveStartX = this.startPos.getX();
        float caveStartY = this.startPos.getY();
        float caveStartZ = this.startPos.getZ();
        int minX = Mth.floor((float)(caveStartX - this.xRadius)) - chunkPos.x * 16 - 1;
        int maxX = Mth.floor((float)(caveStartX + this.xRadius)) - chunkPos.x * 16 + 1;
        int minY = Mth.clamp((int)(Mth.floor((float)(caveStartY - this.yRadius)) - 1), (int)world.getMinBuildHeight(), (int)world.getMaxBuildHeight());
        int maxY = Mth.clamp((int)(Mth.floor((float)(caveStartY + this.yRadius)) + 1), (int)world.getMinBuildHeight(), (int)world.getMaxBuildHeight());
        int minZ = Mth.floor((float)(caveStartZ - this.zRadius)) - chunkPos.z * 16 - 1;
        int maxZ = Mth.floor((float)(caveStartZ + this.zRadius)) - chunkPos.z * 16 + 1;
        minX = Mth.clamp((int)minX, (int)0, (int)15);
        maxX = Mth.clamp((int)maxX, (int)0, (int)15);
        minZ = Mth.clamp((int)minZ, (int)0, (int)15);
        maxZ = Mth.clamp((int)maxZ, (int)0, (int)15);
        for (float x = (float)minX; x <= (float)maxX; x += 1.0f) {
            int globalX = (int)x + chunkPos.x * 16;
            if (globalX < chunkPos.getMinBlockX() || globalX > chunkPos.getMaxBlockX()) continue;
            float radialXDist = ((float)globalX - caveStartX + 0.5f) / this.xRadius;
            for (float z = (float)minZ; z <= (float)maxZ; z += 1.0f) {
                int globalY;
                int globalZ = (int)z + chunkPos.z * 16;
                if (globalZ < chunkPos.getMinBlockZ() || globalZ > chunkPos.getMaxBlockZ()) continue;
                float radialZDist = ((float)globalZ - caveStartZ + 0.5f) / this.zRadius;
                for (float y = (float)minY; y <= (float)maxY && (globalY = (int)y) <= surface[(int)x % 16 * 16 + (int)z % 16]; y += 1.0f) {
                    BlockState state;
                    float radialYDist = (y - caveStartY - 0.5f) / this.yRadius;
                    int mask = (int)x | (int)z << 4 | (int)(y - (float)world.getMinBuildHeight()) << 8;
                    float radialDist = radialXDist * radialXDist + radialYDist * radialYDist + radialZDist * radialZDist;
                    if ((double)radialDist < 1.0) {
                        if ((float)globalX == caveStartX && (float)globalZ == caveStartZ && (float)globalY > caveStartY) {
                            this.placeBlock(world, Blocks.WHITE_WOOL.defaultBlockState(), globalX, globalY, globalZ, box);
                            continue;
                        }
                        if (carvingMask.get(mask) || BLOCK_BLACKLIST.contains(this.getBlock((BlockGetter)world, globalX, globalY, globalZ, box).getBlock())) continue;
                        this.placeBlock(world, Blocks.CAVE_AIR.defaultBlockState(), globalX, globalY, globalZ, box);
                        carvingMask.set(mask);
                        continue;
                    }
                    float radialXDistShell = ((float)globalX - caveStartX + 0.5f) / (this.xRadius + 1.2f);
                    float radialYDistShell = (y - caveStartY - 0.5f) / (this.yRadius + 1.2f);
                    float radialZDistShell = ((float)globalZ - caveStartZ + 0.5f) / (this.zRadius + 1.2f);
                    float radialDistShell = radialXDistShell * radialXDistShell + radialYDistShell * radialYDistShell + radialZDistShell * radialZDistShell;
                    if (!((double)radialDistShell < 1.0)) continue;
                    if ((float)globalX == caveStartX && (float)globalZ == caveStartZ && (float)globalY > caveStartY) {
                        this.placeBlock(world, Blocks.WHITE_WOOL.defaultBlockState(), globalX, globalY, globalZ, box);
                        continue;
                    }
                    if (carvingMask.get(mask) || BLOCK_BLACKLIST.contains((state = this.getBlock((BlockGetter)world, globalX, globalY, globalZ, box)).getBlock()) || !state.isAir() || state.getFluidState().getType() == Fluids.EMPTY && !(decoRand.nextFloat() < 0.8f)) continue;
                    this.placeBlock(world, shellSelector.get((RandomSource)decoRand), globalX, globalY, globalZ, box);
                }
            }
        }
        this.placeSphereRandomized(world, box, (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ, 2.0f, (RandomSource)decoRand, 0.5f, WOOL_SELECTOR, true);
        this.placeBlock(world, Blocks.WHITE_WOOL.defaultBlockState(), (int)caveStartX + 1, (int)caveStartY + 1, (int)caveStartZ, box);
        this.placeBlock(world, Blocks.WHITE_WOOL.defaultBlockState(), (int)caveStartX - 1, (int)caveStartY + 1, (int)caveStartZ, box);
        this.placeBlock(world, Blocks.WHITE_WOOL.defaultBlockState(), (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ + 1, box);
        this.placeBlock(world, Blocks.WHITE_WOOL.defaultBlockState(), (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ - 1, box);
        this.placeBlock(world, Blocks.WHITE_WOOL.defaultBlockState(), (int)caveStartX, (int)caveStartY, (int)caveStartZ, box);
        this.placeSphereRandomized(world, box, (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ, 3.0f, (RandomSource)decoRand, 0.5f, COBWEB_SELECTOR, true);
        this.placeBlock(world, Blocks.SPAWNER.defaultBlockState(), (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ, box);
        if (box.isInside((Vec3i)this.startPos)) {
            BlockEntity spawnerTileEntity = world.getBlockEntity(this.startPos.relative(Direction.UP));
            if (spawnerTileEntity instanceof SpawnerBlockEntity) {
                ((SpawnerBlockEntity)spawnerTileEntity).setEntityId(EntityType.CAVE_SPIDER, randomSource);
            } else {
                BetterDungeonsCommon.LOGGER.warn("Expected cave spider spawner entity at {}, but found none!", (Object)this.startPos.relative(Direction.UP));
            }
        }
        this.decorateCave(world, (RandomSource)decoRand, chunkPos, box, carvingMask);
    }
}

