/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.common.entity;

import com.teamabnormals.pet_cemetery.common.entity.ZombiePet;
import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ZombieWolf
extends Wolf
implements ZombiePet {
    private static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.defineId(ZombieWolf.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int conversionTime;
    private UUID conversionStarter;

    public ZombieWolf(EntityType<? extends ZombieWolf> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Wolf.createAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(50.0);
            this.setHealth(50.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(10.0);
        }
    }

    @Override
    public EntityType<? extends LivingEntity> getConversionType() {
        return EntityType.WOLF;
    }

    public ZombieWolf getBreedOffspring(ServerLevel level, AgeableMob ageableMob) {
        ZombieWolf wolf = (ZombieWolf)((EntityType)PCEntityTypes.ZOMBIE_WOLF.get()).create((Level)level);
        if (wolf != null && ageableMob instanceof Wolf) {
            Wolf parent = (Wolf)ageableMob;
            wolf.setVariant(this.random.nextBoolean() ? this.getVariant() : parent.getVariant());
            if (this.isTame()) {
                wolf.setOwnerUUID(this.getOwnerUUID());
                wolf.setTame(true, true);
                wolf.setCollarColor(this.random.nextBoolean() ? this.getCollarColor() : parent.getCollarColor());
            }
        }
        return wolf;
    }

    public Wolf finalizeConversionSpawn(ServerLevel level) {
        Wolf wolf = (Wolf)this.convertTo(EntityType.WOLF, false);
        if (wolf != null) {
            wolf.setCollarColor(this.getCollarColor());
            wolf.setTame(this.isTame(), true);
            wolf.setOrderedToSit(this.isOrderedToSit());
            if (this.getOwner() != null) {
                wolf.setOwnerUUID(this.getOwner().getUUID());
            }
            wolf.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(wolf.blockPosition()), MobSpawnType.CONVERSION, null);
            wolf.setVariant(this.getVariant());
        }
        return wolf;
    }

    @Override
    public int getConversionTime() {
        return this.conversionTime;
    }

    @Override
    public void setConversionTime(int conversionTime) {
        this.conversionTime = conversionTime;
    }

    @Override
    public UUID getConversionStarter() {
        return this.conversionStarter;
    }

    @Override
    public void setConversionStarter(UUID conversionStarter) {
        this.conversionStarter = conversionStarter;
    }

    @Override
    public EntityDataAccessor<Boolean> getConversionData() {
        return CONVERTING;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.defineConvertingSynchedData(builder);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addConvertingSavaData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readConvertingSavaData(tag);
    }

    public void tick() {
        this.tickConversionProgress();
        super.tick();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result = this.attemptCureZombie(player, hand);
        return result.indicateItemUse() ? result : super.mobInteract(player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (!this.playCureSound(id)) {
            super.handleEntityEvent(id);
        }
    }
}

