/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flowerpatch.registration;

import com.mrbysco.flowerpatch.block.CompatPatchBlock;
import com.mrbysco.flowerpatch.registration.RegistrationProvider;
import com.mrbysco.flowerpatch.registration.RegistryObject;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class CompatRegistry {
    public static final RegistrationProvider<Block> BLOCKS = RegistrationProvider.get(Registries.BLOCK, "flowerpatch");

    public static RegistryObject<Block> registerPatch(String block) {
        ResourceLocation blockLoc = ResourceLocation.parse((String)block);
        return BLOCKS.register(blockLoc.getPath() + "_patch", () -> new CompatPatchBlock((Holder<MobEffect>)MobEffects.UNLUCK, 7, blockLoc, blockLoc.getPath(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_TULIP).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ)));
    }

    public static RegistryObject<Block> registerPatch(String block, String textureName) {
        ResourceLocation blockLoc = ResourceLocation.parse((String)block);
        return BLOCKS.register(blockLoc.getPath() + "_patch", () -> new CompatPatchBlock((Holder<MobEffect>)MobEffects.UNLUCK, 7, blockLoc, textureName, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_TULIP).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ)));
    }

    public static class RegionsUnexploredCompat {
        public static final RegistryObject<Block> ALPHA_DANDELION_PATCH = CompatRegistry.registerPatch("regions_unexplored:alpha_dandelion");
        public static final RegistryObject<Block> ALPHA_ROSE_PATCH = CompatRegistry.registerPatch("regions_unexplored:alpha_rose");
        public static final RegistryObject<Block> ASTER_PATCH = CompatRegistry.registerPatch("regions_unexplored:aster");
        public static final RegistryObject<Block> BLACK_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:black_snowbelle");
        public static final RegistryObject<Block> BLEEDING_HEART_PATCH = CompatRegistry.registerPatch("regions_unexplored:bleeding_heart");
        public static final RegistryObject<Block> BLUE_LUPINE_PATCH = CompatRegistry.registerPatch("regions_unexplored:blue_lupine", "lupine_blue");
        public static final RegistryObject<Block> BLUE_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:blue_snowbelle");
        public static final RegistryObject<Block> BROWN_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:brown_snowbelle");
        public static final RegistryObject<Block> CYAN_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:cyan_snowbelle");
        public static final RegistryObject<Block> DAISY_PATCH = CompatRegistry.registerPatch("regions_unexplored:daisy");
        public static final RegistryObject<Block> DORCEL_PATCH = CompatRegistry.registerPatch("regions_unexplored:dorcel");
        public static final RegistryObject<Block> FELICIA_DAISY_PATCH = CompatRegistry.registerPatch("regions_unexplored:felicia_daisy");
        public static final RegistryObject<Block> FIREWEED_PATCH = CompatRegistry.registerPatch("regions_unexplored:fireweed");
        public static final RegistryObject<Block> GLISTERING_BLOOM_PATCH = CompatRegistry.registerPatch("regions_unexplored:glistering_bloom");
        public static final RegistryObject<Block> GRAY_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:gray_snowbelle");
        public static final RegistryObject<Block> GREEN_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:green_snowbelle");
        public static final RegistryObject<Block> HIBISCUS_PATCH = CompatRegistry.registerPatch("regions_unexplored:hibiscus");
        public static final RegistryObject<Block> HYSSOP_PATCH = CompatRegistry.registerPatch("regions_unexplored:hyssop");
        public static final RegistryObject<Block> LIGHT_BLUE_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:light_blue_snowbelle");
        public static final RegistryObject<Block> LIGHT_GRAY_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:light_gray_snowbelle");
        public static final RegistryObject<Block> LIME_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:lime_snowbelle");
        public static final RegistryObject<Block> MAGENTA_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:magenta_snowbelle");
        public static final RegistryObject<Block> MALLOW_PATCH = CompatRegistry.registerPatch("regions_unexplored:mallow");
        public static final RegistryObject<Block> ORANGE_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:orange_snowbelle");
        public static final RegistryObject<Block> PINK_LUPINE_PATCH = CompatRegistry.registerPatch("regions_unexplored:pink_lupine", "lupine_pink");
        public static final RegistryObject<Block> PINK_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:pink_snowbelle");
        public static final RegistryObject<Block> POPPY_BUSH_PATCH = CompatRegistry.registerPatch("regions_unexplored:poppy_bush");
        public static final RegistryObject<Block> PURPLE_LUPINE_PATCH = CompatRegistry.registerPatch("regions_unexplored:purple_lupine", "lupine_purple");
        public static final RegistryObject<Block> PURPLE_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:purple_snowbelle");
        public static final RegistryObject<Block> RED_LUPINE_PATCH = CompatRegistry.registerPatch("regions_unexplored:red_lupine", "lupine_red");
        public static final RegistryObject<Block> RED_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:red_snowbelle");
        public static final RegistryObject<Block> SALMON_POPPY_BUSH_PATCH = CompatRegistry.registerPatch("regions_unexplored:salmon_poppy_bush", "poppy_bush_salmon");
        public static final RegistryObject<Block> TSUBAKI_PATCH = CompatRegistry.registerPatch("regions_unexplored:tsubaki");
        public static final RegistryObject<Block> WARATAH_PATCH = CompatRegistry.registerPatch("regions_unexplored:waratah");
        public static final RegistryObject<Block> WHITE_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:white_snowbelle");
        public static final RegistryObject<Block> WHITE_TRILLIUM_PATCH = CompatRegistry.registerPatch("regions_unexplored:white_trillium", "trillium_white");
        public static final RegistryObject<Block> WILTING_TRILLIUM_PATCH = CompatRegistry.registerPatch("regions_unexplored:wilting_trillium");
        public static final RegistryObject<Block> YELLOW_LUPINE_PATCH = CompatRegistry.registerPatch("regions_unexplored:yellow_lupine", "lupine_yellow");
        public static final RegistryObject<Block> YELLOW_SNOWBELLE_PATCH = CompatRegistry.registerPatch("regions_unexplored:yellow_snowbelle");

        public static void loadClass() {
        }
    }

    public static class EternalStarlightCompat {
        public static final RegistryObject<Block> AUREATE_FLOWER_PATCH = CompatRegistry.registerPatch("eternal_starlight:aureate_flower");
        public static final RegistryObject<Block> BLUE_CRYSTALFLEUR_PATCH = CompatRegistry.registerPatch("eternal_starlight:blue_crystalfleur");
        public static final RegistryObject<Block> CONEBLOOM_PATCH = CompatRegistry.registerPatch("eternal_starlight:conebloom");
        public static final RegistryObject<Block> DESERT_AMETHYSIA_PATCH = CompatRegistry.registerPatch("eternal_starlight:desert_amethysia");
        public static final RegistryObject<Block> NIGHTFAN_PATCH = CompatRegistry.registerPatch("eternal_starlight:nightfan");
        public static final RegistryObject<Block> PINK_ROSE_PATCH = CompatRegistry.registerPatch("eternal_starlight:pink_rose");
        public static final RegistryObject<Block> RED_CRYSTALFLEUR_PATCH = CompatRegistry.registerPatch("eternal_starlight:red_crystalfleur");
        public static final RegistryObject<Block> RED_VELVETUMOSS_FLOWER_PATCH = CompatRegistry.registerPatch("eternal_starlight:red_velvetumoss_flower");
        public static final RegistryObject<Block> STARLIGHT_FLOWER_PATCH = CompatRegistry.registerPatch("eternal_starlight:starlight_flower");
        public static final RegistryObject<Block> STARLIGHT_TORCHFLOWER_PATCH = CompatRegistry.registerPatch("eternal_starlight:starlight_torchflower");
        public static final RegistryObject<Block> SWAMP_ROSE_PATCH = CompatRegistry.registerPatch("eternal_starlight:swamp_rose");
        public static final RegistryObject<Block> WHISPERBLOOM_PATCH = CompatRegistry.registerPatch("eternal_starlight:whisperbloom");
        public static final RegistryObject<Block> WITHERED_DESERT_AMETHYSIA_PATCH = CompatRegistry.registerPatch("eternal_starlight:withered_desert_amethysia");
        public static final RegistryObject<Block> WITHERED_STARLIGHT_FLOWER_PATCH = CompatRegistry.registerPatch("eternal_starlight:withered_starlight_flower");

        public static void loadClass() {
        }
    }

    public static class BiomesWeveGoneCompat {
        public static final RegistryObject<Block> ALPINE_BELLFLOWER_PATCH = CompatRegistry.registerPatch("biomeswevegone:alpine_bellflower");
        public static final RegistryObject<Block> AMARANTH_PATCH = CompatRegistry.registerPatch("biomeswevegone:amaranth");
        public static final RegistryObject<Block> ANGELICA_PATCH = CompatRegistry.registerPatch("biomeswevegone:angelica");
        public static final RegistryObject<Block> BEGONIA_PATCH = CompatRegistry.registerPatch("biomeswevegone:begonia");
        public static final RegistryObject<Block> BISTORT_PATCH = CompatRegistry.registerPatch("biomeswevegone:bistort");
        public static final RegistryObject<Block> BLACK_ROSE_PATCH = CompatRegistry.registerPatch("biomeswevegone:black_rose");
        public static final RegistryObject<Block> BLUE_SAGE_PATCH = CompatRegistry.registerPatch("biomeswevegone:blue_sage");
        public static final RegistryObject<Block> CALIFORNIA_POPPY_PATCH = CompatRegistry.registerPatch("biomeswevegone:california_poppy");
        public static final RegistryObject<Block> CROCUS_PATCH = CompatRegistry.registerPatch("biomeswevegone:crocus");
        public static final RegistryObject<Block> CYAN_AMARANTH_PATCH = CompatRegistry.registerPatch("biomeswevegone:cyan_amaranth");
        public static final RegistryObject<Block> CYAN_ROSE_PATCH = CompatRegistry.registerPatch("biomeswevegone:cyan_rose");
        public static final RegistryObject<Block> CYAN_TULIP_PATCH = CompatRegistry.registerPatch("biomeswevegone:cyan_tulip");
        public static final RegistryObject<Block> DAFFODIL_PATCH = CompatRegistry.registerPatch("biomeswevegone:daffodil");
        public static final RegistryObject<Block> FAIRY_SLIPPER_PATCH = CompatRegistry.registerPatch("biomeswevegone:fairy_slipper");
        public static final RegistryObject<Block> GREEN_TULIP_PATCH = CompatRegistry.registerPatch("biomeswevegone:green_tulip");
        public static final RegistryObject<Block> GUZMANIA_PATCH = CompatRegistry.registerPatch("biomeswevegone:guzmania");
        public static final RegistryObject<Block> INCAN_LILY_PATCH = CompatRegistry.registerPatch("biomeswevegone:incan_lily");
        public static final RegistryObject<Block> IRIS_PATCH = CompatRegistry.registerPatch("biomeswevegone:iris");
        public static final RegistryObject<Block> KOVAN_FLOWER_PATCH = CompatRegistry.registerPatch("biomeswevegone:kovan_flower");
        public static final RegistryObject<Block> LAZARUS_BELLFLOWER_PATCH = CompatRegistry.registerPatch("biomeswevegone:lazarus_bellflower");
        public static final RegistryObject<Block> LOLLIPOP_FLOWER_PATCH = CompatRegistry.registerPatch("biomeswevegone:lollipop_flower");
        public static final RegistryObject<Block> MAGENTA_AMARANTH_PATCH = CompatRegistry.registerPatch("biomeswevegone:magenta_amaranth");
        public static final RegistryObject<Block> MAGENTA_TULIP_PATCH = CompatRegistry.registerPatch("biomeswevegone:magenta_tulip");
        public static final RegistryObject<Block> ORANGE_AMARANTH_PATCH = CompatRegistry.registerPatch("biomeswevegone:orange_amaranth");
        public static final RegistryObject<Block> ORANGE_DAISY_PATCH = CompatRegistry.registerPatch("biomeswevegone:orange_daisy");
        public static final RegistryObject<Block> OSIRIA_ROSE_PATCH = CompatRegistry.registerPatch("biomeswevegone:osiria_rose");
        public static final RegistryObject<Block> PEACH_LEATHER_FLOWER_PATCH = CompatRegistry.registerPatch("biomeswevegone:peach_leather_flower");
        public static final RegistryObject<Block> PINK_ALLIUM_PATCH = CompatRegistry.registerPatch("biomeswevegone:pink_allium");
        public static final RegistryObject<Block> PINK_ANEMONE_PATCH = CompatRegistry.registerPatch("biomeswevegone:pink_anemone");
        public static final RegistryObject<Block> PINK_DAFFODIL_PATCH = CompatRegistry.registerPatch("biomeswevegone:pink_daffodil");
        public static final RegistryObject<Block> PROTEA_FLOWER_PATCH = CompatRegistry.registerPatch("biomeswevegone:protea_flower");
        public static final RegistryObject<Block> PURPLE_AMARANTH_PATCH = CompatRegistry.registerPatch("biomeswevegone:purple_amaranth");
        public static final RegistryObject<Block> PURPLE_SAGE_PATCH = CompatRegistry.registerPatch("biomeswevegone:purple_sage");
        public static final RegistryObject<Block> PURPLE_TULIP_PATCH = CompatRegistry.registerPatch("biomeswevegone:purple_tulip");
        public static final RegistryObject<Block> RICHEA_PATCH = CompatRegistry.registerPatch("biomeswevegone:richea");
        public static final RegistryObject<Block> ROSE_PATCH = CompatRegistry.registerPatch("biomeswevegone:rose");
        public static final RegistryObject<Block> SILVER_VASE_FLOWER_PATCH = CompatRegistry.registerPatch("biomeswevegone:silver_vase_flower");
        public static final RegistryObject<Block> SNOWDROPS_PATCH = CompatRegistry.registerPatch("biomeswevegone:snowdrops");
        public static final RegistryObject<Block> VIOLET_LEATHER_FLOWER_PATCH = CompatRegistry.registerPatch("biomeswevegone:violet_leather_flower");
        public static final RegistryObject<Block> WHITE_ALLIUM_PATCH = CompatRegistry.registerPatch("biomeswevegone:white_allium");
        public static final RegistryObject<Block> WHITE_ANEMONE_PATCH = CompatRegistry.registerPatch("biomeswevegone:white_anemone");
        public static final RegistryObject<Block> WHITE_SAGE_PATCH = CompatRegistry.registerPatch("biomeswevegone:white_sage");
        public static final RegistryObject<Block> WINTER_CYCLAMEN_PATCH = CompatRegistry.registerPatch("biomeswevegone:winter_cyclamen");
        public static final RegistryObject<Block> WINTER_ROSE_PATCH = CompatRegistry.registerPatch("biomeswevegone:winter_rose");
        public static final RegistryObject<Block> WINTER_SCILLA_PATCH = CompatRegistry.registerPatch("biomeswevegone:winter_scilla");
        public static final RegistryObject<Block> YELLOW_DAFFODIL_PATCH = CompatRegistry.registerPatch("biomeswevegone:yellow_daffodil");
        public static final RegistryObject<Block> YELLOW_TULIP_PATCH = CompatRegistry.registerPatch("biomeswevegone:yellow_tulip");

        public static void loadClass() {
        }
    }
}

