/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flowerpatch.block;

import com.mrbysco.flowerpatch.block.PatchBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MushroomPatchBlock
extends MushroomBlock
implements PatchBlock {
    public static final int MAX_MUSHROOMS = 4;
    public static final IntegerProperty MUSHROOMS = IntegerProperty.create((String)"mushrooms", (int)2, (int)4);
    protected static final VoxelShape ONE_AABB = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    protected static final VoxelShape TWO_AABB = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    protected static final VoxelShape THREE_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    protected static final VoxelShape FOUR_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    private final Supplier<Block> mushroomDelegate;

    public MushroomPatchBlock(Supplier<Block> mushroomSupplier, BlockBehaviour.Properties properties) {
        super(null, properties);
        this.mushroomDelegate = mushroomSupplier;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MUSHROOMS, (Comparable)Integer.valueOf(2)));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext placeContext) {
        return super.canBeReplaced(state, placeContext) && placeContext.getItemInHand().getItem() == this.mushroomDelegate.get().asItem();
    }

    @Override
    public Supplier<Block> getPatchDelegate() {
        return this.mushroomDelegate;
    }

    @Override
    public IntegerProperty getProperty() {
        return MUSHROOMS;
    }

    @Override
    public int getMaxAmount() {
        return 4;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        Vec3 vec3 = state.getOffset(blockGetter, pos);
        return switch ((Integer)state.getValue((Property)MUSHROOMS)) {
            default -> ONE_AABB.move(vec3.x, vec3.y, vec3.z);
            case 2 -> TWO_AABB.move(vec3.x, vec3.y, vec3.z);
            case 3 -> THREE_AABB.move(vec3.x, vec3.y, vec3.z);
            case 4 -> FOUR_AABB.move(vec3.x, vec3.y, vec3.z);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{MUSHROOMS});
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.mushroomDelegate.get());
    }

    public boolean growMushroom(ServerLevel serverLevel, BlockPos pos, BlockState state, RandomSource randomSource) {
        return false;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos pos, BlockState state) {
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos pos, BlockState state) {
        return false;
    }

    public void performBonemeal(ServerLevel level, RandomSource randomSource, BlockPos pos, BlockState state) {
    }
}

