/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.worldgen.treedecorators;

import com.blackgear.vanillabackport.common.registries.ModTreeDecorators;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class AttachedToLogsDecorator
extends TreeDecorator {
    public static final MapCodec<AttachedToLogsDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(decorator -> decorator.blockProvider), (App)ExtraCodecs.nonEmptyList((Codec)Direction.CODEC.listOf()).fieldOf("directions").forGetter(decorator -> decorator.directions)).apply((Applicative)instance, AttachedToLogsDecorator::new));
    private final float probability;
    private final BlockStateProvider blockProvider;
    private final List<Direction> directions;

    public AttachedToLogsDecorator(float probability, BlockStateProvider blockProvider, List<Direction> directions) {
        this.probability = probability;
        this.blockProvider = blockProvider;
        this.directions = directions;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        for (BlockPos pos : Util.shuffledCopy((ObjectArrayList)context.logs(), (RandomSource)random)) {
            Direction direction = (Direction)Util.getRandom(this.directions, (RandomSource)random);
            BlockPos offset = pos.relative(direction);
            if (!(random.nextFloat() <= this.probability) || !context.isAir(offset)) continue;
            context.setBlock(offset, this.blockProvider.getState(random, offset));
        }
    }

    protected TreeDecoratorType<?> type() {
        return ModTreeDecorators.ATTACHED_TO_LOGS.get();
    }
}

