/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.happyghast;

import com.blackgear.vanillabackport.common.level.entities.happyghast.GhastlingFollowAdult;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import com.blackgear.vanillabackport.common.registries.ModSensorTypes;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class HappyGhastAi {
    private static final float IDLE_SPEED = 1.0f;
    private static final float TEMPTED_SPEED = 1.25f;
    private static final float FOLLOWING_ADULT_SPEED = 1.1f;
    private static final double CLOSE_ENOUGH_DIST = 5.0;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final ImmutableList<SensorType<? extends Sensor<? super HappyGhast>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, ModSensorTypes.HAPPY_GHAST_TEMPTATIONS.get(), ModSensorTypes.NEAREST_ADULT_ANY_TYPE.get(), (Object)SensorType.NEAREST_PLAYERS);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED, (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_PLAYERS, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER});

    public static Brain.Provider<HappyGhast> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected static Brain<?> makeBrain(Brain<HappyGhast> brain) {
        HappyGhastAi.initCoreActivity(brain);
        HappyGhastAi.initIdleActivity(brain);
        HappyGhastAi.initPanicActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<HappyGhast> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<HappyGhast> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)1, (Object)new FollowTemptation(entity -> Float.valueOf(1.25f), entity -> 5.0)), (Object)Pair.of((Object)2, GhastlingFollowAdult.create(ADULT_FOLLOW_RANGE, entity -> Float.valueOf(1.1f), (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.NEAREST_VISIBLE_PLAYER)), (Object)Pair.of((Object)3, GhastlingFollowAdult.create(ADULT_FOLLOW_RANGE, entity -> Float.valueOf(1.1f), (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.NEAREST_VISIBLE_ADULT)), (Object)Pair.of((Object)4, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.fly((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1))))));
    }

    private static void initPanicActivity(Brain<HappyGhast> brain) {
        brain.addActivityWithConditions(Activity.PANIC, ImmutableList.of(), Set.of(Pair.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivity(HappyGhast happyGhast) {
        happyGhast.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.PANIC, (Object)Activity.IDLE));
    }
}

