/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.util.UndashedUuid;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.integration.PermissionsHelper;
import dev.ftb.mods.ftbquests.net.CreateOtherTeamDataMessage;
import dev.ftb.mods.ftbquests.net.DeleteObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.MoveChapterGroupResponseMessage;
import dev.ftb.mods.ftbquests.net.SyncEditorPermissionMessage;
import dev.ftb.mods.ftbquests.net.SyncQuestsMessage;
import dev.ftb.mods.ftbquests.net.SyncTeamDataMessage;
import dev.ftb.mods.ftbquests.net.TeamDataChangedMessage;
import dev.ftb.mods.ftbquests.net.TeamDataUpdate;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.util.FTBQuestsInventoryListener;
import dev.ftb.mods.ftbquests.util.FileUtils;
import dev.ftb.mods.ftbquests.util.PlayerInventorySummary;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.level.storage.LevelResource;

public class ServerQuestFile
extends BaseQuestFile {
    public static final LevelResource FTBQUESTS_DATA = new LevelResource("ftbquests");
    public static ServerQuestFile INSTANCE;
    public final MinecraftServer server;
    private boolean shouldSave;
    private boolean isLoading;
    private Path folder;
    private ServerPlayer currentPlayer = null;

    public ServerQuestFile(MinecraftServer s) {
        this.server = s;
        this.shouldSave = false;
        this.isLoading = false;
        int taskTypeId = 0;
        for (TaskType type : TaskTypes.TYPES.values()) {
            type.internalId = ++taskTypeId;
            this.taskTypeIds.put(type.internalId, (Object)type);
        }
        int rewardTypeId = 0;
        for (RewardType type : RewardTypes.TYPES.values()) {
            type.intId = ++rewardTypeId;
            this.rewardTypeIds.put(type.intId, (Object)type);
        }
    }

    public void load() {
        this.load(true, true);
    }

    public void load(boolean quests, boolean progression) {
        Path path;
        this.folder = Platform.getConfigFolder().resolve("ftbquests/quests");
        if (quests && Files.exists(this.folder, new LinkOption[0])) {
            FTBQuests.LOGGER.info("Loading quests from {}", (Object)this.folder);
            this.isLoading = true;
            this.readDataFull(this.folder, (HolderLookup.Provider)this.server.registryAccess());
            this.isLoading = false;
        }
        if (progression && Files.exists(path = this.server.getWorldPath(FTBQUESTS_DATA), new LinkOption[0])) {
            try (Stream<Path> s = Files.list(path);){
                s.filter(p -> p.getFileName().toString().contains("-") && p.getFileName().toString().endsWith(".snbt")).forEach(path1 -> {
                    SNBTCompoundTag nbt = SNBT.read((Path)path1);
                    if (nbt != null) {
                        try {
                            UUID uuid = UndashedUuid.fromString((String)nbt.getString("uuid"));
                            TeamData data = new TeamData(uuid, this);
                            this.addData(data, true);
                            data.deserializeNBT(nbt);
                        }
                        catch (Exception ex) {
                            FTBQuests.LOGGER.error("can't parse progression data for {}: {}", path1, (Object)ex.getMessage());
                        }
                    }
                });
            }
            catch (Exception ex) {
                FTBQuests.LOGGER.error("can't read directory {}: {}", (Object)path, (Object)ex.getMessage());
            }
        }
    }

    @Override
    public Env getSide() {
        return Env.SERVER;
    }

    @Override
    public HolderLookup.Provider holderLookup() {
        return this.server.registryAccess();
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    public Path getFolder() {
        return this.folder;
    }

    @Override
    public void deleteObject(long id) {
        QuestObjectBase object = this.getBase(id);
        if (object != null) {
            this.getTranslationManager().removeAllTranslations(object);
            object.deleteChildren();
            object.deleteSelf();
            this.refreshIDMap();
            this.markDirty();
            object.getPath().ifPresent(path -> FileUtils.delete(this.getFolder().resolve((String)path).toFile()));
        }
        NetworkHelper.sendToAll((MinecraftServer)this.server, (CustomPacketPayload)new DeleteObjectResponseMessage(id));
    }

    @Override
    public void markDirty() {
        this.shouldSave = true;
    }

    public void saveNow() {
        if (this.shouldSave) {
            this.writeDataFull(this.getFolder(), (HolderLookup.Provider)this.server.registryAccess());
            this.shouldSave = false;
        }
        this.getTranslationManager().saveToNBT(this.getFolder().resolve("lang"), false);
        this.getAllTeamData().forEach(TeamData::saveIfChanged);
    }

    public void unload() {
        this.saveNow();
        this.deleteChildren();
        this.deleteSelf();
    }

    public ServerPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void withPlayerContext(ServerPlayer player, Runnable toDo) {
        this.currentPlayer = player;
        try {
            toDo.run();
        }
        finally {
            this.currentPlayer = null;
        }
    }

    public void playerLoggedIn(PlayerLoggedInAfterTeamEvent event) {
        ServerPlayer player = event.getPlayer();
        TeamData data = this.getOrCreateTeamData(event.getTeam());
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncQuestsMessage(this));
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncEditorPermissionMessage(PermissionsHelper.hasEditorPermission(player, false)));
        this.getTranslationManager().sendTranslationsToPlayer(player);
        player.inventoryMenu.addSlotListener((ContainerListener)new FTBQuestsInventoryListener(player));
        this.checkQuestBookOnLogin(data, player);
    }

    private void checkQuestBookOnLogin(TeamData data, ServerPlayer player) {
        if (!data.isLocked()) {
            this.withPlayerContext(player, () -> {
                Collection<ServerPlayer> onlineMembers = data.getOnlineMembers();
                List<ServerPlayer> pList = List.of(player);
                Date now = new Date();
                PlayerInventorySummary.build(player);
                this.forAllQuests(quest -> {
                    if (!data.isCompleted((QuestObject)quest) && quest.isCompletedRaw(data)) {
                        quest.onCompleted(new QuestProgressEventData<Quest>(now, data, (Quest)quest, onlineMembers, (Collection<ServerPlayer>)pList));
                    }
                    data.checkAutoCompletion((Quest)quest);
                    if (data.canStartTasks((Quest)quest)) {
                        quest.getTasks().stream().filter(Task::checkOnLogin).forEach(task -> task.submitTask(data, player));
                    }
                });
            });
        }
    }

    public void teamCreated(TeamCreatedEvent event) {
        UUID id = event.getTeam().getId();
        TeamData data = this.teamDataMap.computeIfAbsent(id, k -> {
            TeamData newTeamData = new TeamData(id, this);
            newTeamData.markDirty();
            return newTeamData;
        });
        data.setName(event.getTeam().getShortName());
        this.addData(data, false);
        if (event.getTeam() instanceof PartyTeam) {
            FTBTeamsAPI.api().getManager().getPlayerTeamForPlayerID(event.getCreator().getUUID()).ifPresent(playerTeam -> {
                TeamData oldTeamData = this.getOrCreateTeamData((Team)playerTeam);
                data.copyData(oldTeamData);
            });
        }
        NetworkHelper.sendToAll((MinecraftServer)this.server, (CustomPacketPayload)new CreateOtherTeamDataMessage(TeamDataUpdate.forTeamData(data)));
    }

    public void playerChangedTeam(PlayerChangedTeamEvent event) {
        event.getPreviousTeam().ifPresent(prevTeam -> {
            Team curTeam = event.getTeam();
            TeamData oldTeamData = this.getOrCreateTeamData((Team)prevTeam);
            TeamData newTeamData = this.getOrCreateTeamData(curTeam);
            if (prevTeam.isPlayerTeam() && curTeam.isPartyTeam() && !curTeam.getOwner().equals(event.getPlayerId())) {
                newTeamData.mergeData(oldTeamData);
                this.withPlayerContext(event.getPlayer(), () -> this.forAllQuests(newTeamData::checkAutoCompletion));
            } else if (prevTeam.isPartyTeam() && curTeam.isPlayerTeam()) {
                newTeamData.mergeClaimedRewards(oldTeamData);
            }
            NetworkHelper.sendToAll((MinecraftServer)this.server, (CustomPacketPayload)new TeamDataChangedMessage(TeamDataUpdate.forTeamData(oldTeamData), TeamDataUpdate.forTeamData(newTeamData)));
            NetworkManager.sendToPlayers((Iterable)curTeam.getOnlineMembers(), (CustomPacketPayload)new SyncTeamDataMessage(newTeamData));
        });
    }

    @Override
    public boolean isPlayerOnTeam(Player player, TeamData teamData) {
        return FTBTeamsAPI.api().getManager().getTeamForPlayerID(player.getUUID()).map(team -> team.getTeamId().equals(teamData.getTeamId())).orElse(false);
    }

    @Override
    public boolean moveChapterGroup(long id, boolean movingUp) {
        if (super.moveChapterGroup(id, movingUp)) {
            this.markDirty();
            this.clearCachedData();
            NetworkHelper.sendToAll((MinecraftServer)this.server, (CustomPacketPayload)new MoveChapterGroupResponseMessage(id, movingUp));
            return true;
        }
        return false;
    }

    @Override
    public String getLocale() {
        return this.getFallbackLocale();
    }
}

