/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.net.ReorderItemResponseMessage;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;

public record ReorderItemMessage(long id, boolean moveRight) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ReorderItemMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("reorder_item"));
    public static final StreamCodec<FriendlyByteBuf, ReorderItemMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, ReorderItemMessage::id, (StreamCodec)ByteBufCodecs.BOOL, ReorderItemMessage::moveRight, ReorderItemMessage::new);

    public static void handle(ReorderItemMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            if (NetUtils.canEdit(context)) {
                QuestObjectBase object = ServerQuestFile.INSTANCE.getBase(message.id);
                if (object instanceof Task) {
                    Task task = (Task)object;
                    if (message.moveRight) {
                        task.getQuest().moveTaskRight(task);
                    } else {
                        task.getQuest().moveTaskLeft(task);
                    }
                    NetworkHelper.sendToAll((MinecraftServer)context.getPlayer().getServer(), (CustomPacketPayload)ReorderItemResponseMessage.tasks(task.getQuest()));
                } else if (object instanceof Reward) {
                    Reward reward = (Reward)object;
                    if (message.moveRight) {
                        reward.getQuest().moveRewardRight(reward);
                    } else {
                        reward.getQuest().moveRewardLeft(reward);
                    }
                    NetworkHelper.sendToAll((MinecraftServer)context.getPlayer().getServer(), (CustomPacketPayload)ReorderItemResponseMessage.rewards(reward.getQuest()));
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

