/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL42;
import team.lodestar.lodestone.systems.texture.InternalTextureFormat;

public class VolumeTexture
extends AbstractTexture {
    private int width;
    private int height;
    private int depth;
    private boolean shouldReload = true;
    private boolean initialized = false;

    public VolumeTexture(int size) {
        this(size, size, size);
    }

    public VolumeTexture(int size, boolean shouldReload) {
        this(size);
        this.shouldReload = shouldReload;
    }

    public VolumeTexture(int width, int height, int depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public VolumeTexture(int width, int height, int depth, boolean shouldReload) {
        this(width, height, depth);
        this.shouldReload = shouldReload;
    }

    public void load(@NotNull ResourceManager resourceManager) {
        if (!this.initialized) {
            this.createEmpty(true, InternalTextureFormat.RGBA16F);
            this.initialized = true;
        } else if (this.shouldReload) {
            this.createEmpty(true, InternalTextureFormat.RGBA16F);
        }
    }

    public void createEmpty(boolean linear, InternalTextureFormat format) {
        this.id = GL12.glGenTextures();
        GL12.glBindTexture((int)32879, (int)this.id);
        GL12.glPixelStorei((int)3317, (int)1);
        GL12.glTexImage3D((int)32879, (int)0, (int)format.getGlFormat(), (int)this.width, (int)this.height, (int)this.depth, (int)0, (int)6408, (int)format.getGlType(), (ByteBuffer)null);
        GL12.glTexParameteri((int)32879, (int)10241, (int)(linear ? 9729 : 9728));
        GL12.glTexParameteri((int)32879, (int)10240, (int)(linear ? 9729 : 9728));
        GL12.glTexParameteri((int)32879, (int)10242, (int)33071);
        GL12.glTexParameteri((int)32879, (int)10243, (int)33071);
        GL12.glTexParameteri((int)32879, (int)32882, (int)33071);
        GL30.glGenerateMipmap((int)32879);
        GL12.glBindTexture((int)32879, (int)0);
        GL42.glBindImageTexture((int)0, (int)this.id, (int)0, (boolean)true, (int)0, (int)35000, (int)34842);
    }

    public void bind() {
        RenderSystem.assertOnRenderThreadOrInit();
        GL12.glBindTexture((int)32879, (int)this.id);
    }

    public void setFilter(boolean blur, boolean mipmap) {
        int j;
        int i;
        RenderSystem.assertOnRenderThreadOrInit();
        this.blur = blur;
        this.mipmap = mipmap;
        if (blur) {
            i = mipmap ? 9987 : 9729;
            j = 9729;
        } else {
            i = mipmap ? 9986 : 9728;
            j = 9728;
        }
        this.bind();
        GlStateManager._texParameter((int)32879, (int)10241, (int)i);
        GlStateManager._texParameter((int)32879, (int)10240, (int)j);
    }
}

