/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.enchanting;

import com.mojang.datafixers.util.Either;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.item.enchantment.effects.RemoveBinomial;
import org.apache.commons.lang3.mutable.MutableFloat;
import team.lodestar.lodestone.systems.enchanting.LodestoneEnchantmentDataHelper;

public class LodestoneEnchantmentValueEffectHelper {
    private static final RandomSource FAKE_ASS_RANDOM_SOURCE = RandomSource.create();

    public static float getAccurateAttackDamage(LivingEntity entity, ItemStack stack) {
        return LodestoneEnchantmentValueEffectHelper.getComponentValue(entity, stack, DataComponents.DAMAGE, (Holder<Attribute>)Attributes.ATTACK_DAMAGE);
    }

    public static float getComponentValue(LivingEntity entity, ItemStack stack, DataComponentType<?> component, Holder<Attribute> base) {
        float baseValue = (float)entity.getAttributeValue(base);
        return LodestoneEnchantmentValueEffectHelper.getComponentValue(stack, component, baseValue);
    }

    public static float getComponentValue(ItemStack item, DataComponentType<?> component, float baseValue) {
        return LodestoneEnchantmentValueEffectHelper.getComponentValue(item, null, component, baseValue);
    }

    public static float getComponentValue(ItemStack item, @Nullable Holder<Enchantment> filter, DataComponentType<?> componentType, float baseValue) {
        return LodestoneEnchantmentValueEffectHelper.getComponentValue(item, item, filter, componentType, baseValue);
    }

    public static float getComponentValue(ItemStack enchantmentHolder, ItemStack effectHolder, @Nullable Holder<Enchantment> filter, DataComponentType<?> componentType, float baseValue) {
        MutableFloat mutable = new MutableFloat(baseValue);
        try {
            LodestoneEnchantmentDataHelper.runIterationOnItem(enchantmentHolder, filter, (enchantment, enchantmentLevel) -> {
                DataComponentMap componentMap = ((Enchantment)enchantment.value()).effects();
                List<EnchantmentValueEffect> effects = LodestoneEnchantmentValueEffectHelper.getValueEffects(effectHolder, componentMap, componentType);
                for (EnchantmentValueEffect effect : effects) {
                    LodestoneEnchantmentValueEffectHelper.processValueEffect(mutable, effect, enchantmentLevel);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mutable.getValue().floatValue();
    }

    public static List<EnchantmentValueEffect> getValueEffects(ItemStack item, DataComponentMap map, DataComponentType<?> type) {
        return LodestoneEnchantmentDataHelper.getMatchingEffects(item, map, EnchantmentValueEffect.class, Either.left(e -> e.type().equals((Object)type)));
    }

    public static void processValueEffect(MutableFloat mutable, EnchantmentValueEffect effect, int enchantmentLevel) {
        RemoveBinomial removeBinomial;
        float f;
        if (effect instanceof RemoveBinomial && (f = (removeBinomial = (RemoveBinomial)effect).chance().calculate(enchantmentLevel)) < 1.0f) {
            mutable.setValue(mutable.getValue().floatValue() / (1.0f - f));
            return;
        }
        mutable.setValue(effect.process(enchantmentLevel, FAKE_ASS_RANDOM_SOURCE, mutable.getValue().floatValue()));
    }
}

