/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.datagen.statesmith;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmith;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneBlockStateProvider;
import team.lodestar.lodestone.systems.datagen.statesmith.AbstractBlockStateSmith;

public class BlockStateSmith<T extends Block>
extends AbstractBlockStateSmith<T> {
    public final SmithStateSupplier<T> stateSupplier;
    public final ItemModelSmith itemModelSmith;

    public BlockStateSmith(Class<T> blockClass, SmithStateSupplier<T> stateSupplier) {
        this(blockClass, ItemModelSmithTypes.BLOCK_MODEL_ITEM, stateSupplier);
    }

    public BlockStateSmith(Class<T> blockClass, ItemModelSmith itemModelSmith, SmithStateSupplier<T> stateSupplier) {
        super(blockClass);
        this.stateSupplier = stateSupplier;
        this.itemModelSmith = itemModelSmith;
    }

    @SafeVarargs
    public final void act(AbstractBlockStateSmith.StateSmithData data, Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> block : blocks) {
            this.act(data, block);
        }
        List.of(blocks).forEach(data.consumer);
    }

    public void act(AbstractBlockStateSmith.StateSmithData data, Collection<Supplier<? extends Block>> blocks) {
        blocks.forEach(r -> this.act(data, (Supplier<? extends Block>)r));
        new ArrayList<Supplier<? extends Block>>(blocks).forEach(data.consumer);
    }

    private void act(AbstractBlockStateSmith.StateSmithData data, Supplier<? extends Block> registryObject) {
        Block block = registryObject.get();
        if (this.blockClass.isInstance(block)) {
            this.stateSupplier.act((Block)this.blockClass.cast(block), data.provider);
            if (!this.itemModelSmith.equals(ItemModelSmithTypes.NO_DATAGEN)) {
                this.itemModelSmith.act(data.provider.itemModelProvider, () -> ((Block)block).asItem());
            }
        } else {
            LodestoneLib.LOGGER.warn("Block does not match the state smith it was assigned: {}", (Object)registryObject.get().toString());
        }
    }

    public static interface SmithStateSupplier<T extends Block> {
        public void act(T var1, LodestoneBlockStateProvider var2);
    }
}

