/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import team.lodestar.lodestone.attachment.WorldEventAttachment;
import team.lodestar.lodestone.command.arguments.WorldEventInstanceArgument;
import team.lodestar.lodestone.command.arguments.WorldEventTypeArgument;
import team.lodestar.lodestone.registry.common.LodestoneAttachmentTypes;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class UnfreezeActiveWorldEventsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unfreeze").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"all").executes(ctx -> {
            WorldEventAttachment worldEventAttachment = (WorldEventAttachment)((CommandSourceStack)ctx.getSource()).getLevel().getData(LodestoneAttachmentTypes.WORLD_EVENT_DATA);
            ArrayList<WorldEventInstance> activeWorldEvents = worldEventAttachment.activeWorldEvents;
            List<WorldEventInstance> currentlyFrozen = activeWorldEvents.stream().filter(WorldEventInstance::isFrozen).toList();
            if (currentlyFrozen.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.lodestone.worldevent.unfreeze.all.fail").withStyle(ChatFormatting.RED));
            } else {
                currentlyFrozen.forEach(instance -> {
                    instance.frozen = false;
                });
                currentlyFrozen.forEach(WorldEventInstance::setDirty);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.lodestone.worldevent.unfreeze.all.success", (Object[])new Object[]{currentlyFrozen.size()}).withStyle(ChatFormatting.AQUA), true);
            }
            return 1;
        }))).then(Commands.literal((String)"single").then(Commands.argument((String)"target", (ArgumentType)WorldEventInstanceArgument.worldEventInstance()).executes(ctx -> {
            WorldEventInstance event = WorldEventInstanceArgument.getEventInstance(ctx, "target");
            if (!event.isFrozen()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.lodestone.worldevent.unfreeze.target.fail").withStyle(ChatFormatting.RED));
            } else {
                event.frozen = false;
                event.setDirty();
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.lodestone.worldevent.unfreeze.target.success", (Object[])new Object[]{event.type.id.toString()}).withStyle(ChatFormatting.AQUA), true);
            }
            return 1;
        })))).then(Commands.literal((String)"type").then(Commands.argument((String)"type", (ArgumentType)WorldEventTypeArgument.worldEventType()).executes(ctx -> {
            WorldEventType type = WorldEventTypeArgument.getEventType(ctx, "type");
            WorldEventAttachment worldEventAttachment = (WorldEventAttachment)((CommandSourceStack)ctx.getSource()).getLevel().getData(LodestoneAttachmentTypes.WORLD_EVENT_DATA);
            List<WorldEventInstance> activeWorldEvents = worldEventAttachment.activeWorldEvents.stream().filter(instance -> instance.type == type).toList();
            List<WorldEventInstance> currentlyFrozen = activeWorldEvents.stream().filter(WorldEventInstance::isFrozen).toList();
            if (currentlyFrozen.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.lodestone.worldevent.unfreeze.type.fail", (Object[])new Object[]{type.id.toString()}).withStyle(ChatFormatting.RED));
            } else {
                currentlyFrozen.forEach(instance -> {
                    instance.frozen = false;
                });
                currentlyFrozen.forEach(WorldEventInstance::setDirty);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.lodestone.worldevent.unfreeze.type.success", (Object[])new Object[]{currentlyFrozen.size(), type.id.toString()}).withStyle(ChatFormatting.AQUA), true);
            }
            return 1;
        })));
    }
}

