/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.effects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class FlammableEffect
extends MobEffect {
    public FlammableEffect() {
        super(MobEffectCategory.HARMFUL, 0xDD4400);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        int ticks = pLivingEntity.getRemainingFireTicks();
        if (ticks <= 0) {
            return true;
        }
        if (ticks <= 160) {
            pLivingEntity.setRemainingFireTicks(8);
        }
        Level level = pLivingEntity.level();
        if ((double)pLivingEntity.getRandom().nextFloat() > 0.5 + (double)pAmplifier * 0.2) {
            return true;
        }
        FireBlock delegate = (FireBlock)Blocks.FIRE;
        if (level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            ArrayList positions = BlockPos.betweenClosedStream((AABB)pLivingEntity.getBoundingBox()).map(BlockPos::immutable).distinct().collect(Collectors.toCollection(ArrayList::new));
            Collections.shuffle(positions);
            for (BlockPos pos : positions) {
                if (level.isRaining() && delegate.isNearRain(level, pos)) continue;
                for (Direction d : Direction.values()) {
                    if (!BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)pos, (Direction)d)) continue;
                    BlockState state = BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos);
                    level.setBlock(pos, state, 3);
                }
            }
        }
        return true;
    }

    public void applyInstantenousEffect(@Nullable Entity pSource, @Nullable Entity pIndirectSource, LivingEntity pLivingEntity, int pAmplifier, double pHealth) {
    }
}

