/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.base.properties;

import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public enum ColorProperty implements StringRepresentable
{
    WHITE,
    ORANGE,
    MAGENTA,
    LIGHT_BLUE,
    YELLOW,
    LIME,
    PINK,
    GRAY,
    LIGHT_GRAY,
    CYAN,
    PURPLE,
    BLUE,
    BROWN,
    GREEN,
    RED,
    BLACK;


    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.getSerializedName();
    }

    public static ColorProperty fromCushion(Item cushion) {
        return ColorProperty.valueOf(BuiltInRegistries.ITEM.getKey((Object)cushion).getPath().replace("_cushion", "").toUpperCase(Locale.ROOT));
    }

    public ItemStack toCushion() {
        return ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"handcrafted", (String)(this.getSerializedName() + "_cushion")))).getDefaultInstance();
    }

    public static ColorProperty fromSheet(Item sheet) {
        return ColorProperty.valueOf(BuiltInRegistries.ITEM.getKey((Object)sheet).getPath().replace("_sheet", "").toUpperCase(Locale.ROOT));
    }

    public ItemStack toSheet() {
        return ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"handcrafted", (String)(this.getSerializedName() + "_sheet")))).getDefaultInstance();
    }
}

