/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util.event;

import com.blackgear.platform.core.util.event.CancellableResult;
import com.blackgear.platform.core.util.event.SimpleEvent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public abstract class Event<T> {
    private static final Map<Method, MethodHandle> METHOD_HANDLE_CACHE = new ConcurrentHashMap<Method, MethodHandle>();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    protected volatile T invoker;

    public T invoker() {
        return this.invoker;
    }

    public abstract void register(T var1);

    public static <T> Event<T> create(Class<? super T> clazz, Function<T[], T> factory) {
        return new SimpleEvent<T>(clazz, factory);
    }

    public static <T> Event<T> create(Class<? super T> type) {
        Class[] interfaces = new Class[]{type};
        ClassLoader classLoader = Event.class.getClassLoader();
        return Event.create(type, callbacks -> Proxy.newProxyInstance(classLoader, interfaces, (proxy, method, args) -> {
            for (Object callback : callbacks) {
                Event.invokeFast(callback, method, args);
            }
            return null;
        }));
    }

    public static <T> Event<T> cancellable(Class<? super T> type) {
        Class[] interfaces = new Class[]{type};
        ClassLoader classLoader = Event.class.getClassLoader();
        return Event.create(type, callbacks -> Proxy.newProxyInstance(classLoader, interfaces, (proxy, method, args) -> {
            for (Object callback : callbacks) {
                CancellableResult result = Objects.requireNonNull((CancellableResult)((Object)((Object)((Object)Event.invokeFast(callback, method, args)))));
                if (!result.isCancelled()) continue;
                return result;
            }
            return CancellableResult.pass();
        }));
    }

    private static <T, S> S invokeFast(T callback, Method method, Object[] args) throws Throwable {
        MethodHandle handle = METHOD_HANDLE_CACHE.computeIfAbsent(method, m -> {
            try {
                return LOOKUP.unreflect((Method)m);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to create MethodHandle for " + String.valueOf(m), e);
            }
        });
        return (S)(args == null || args.length == 0 ? handle.invoke(callback) : handle.bindTo(callback).invokeWithArguments(args));
    }
}

