/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.util.SneakyUtils;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.lib.nbt.IListTag;
import net.creeperhost.levelio.lib.nbt.ITag;
import net.creeperhost.levelio.lib.nbt.NBTHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCNBTImpl
implements NBTHandler {
    private static InputStream handleCompression(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(is, 2);
        int signature = (pbis.read() & 0xFF) + (pbis.read() << 8);
        pbis.unread(signature >> 8);
        pbis.unread(signature & 0xFF);
        if (signature == 35615) {
            return new GZIPInputStream(pbis);
        }
        return pbis;
    }

    @Override
    @Nullable
    public ICompoundTag read(Path path) throws IOException {
        try (InputStream is = MCNBTImpl.handleCompression(Files.newInputStream(path, new OpenOption[0]));){
            ICompoundTag iCompoundTag = this.read(is);
            return iCompoundTag;
        }
    }

    @Override
    @Nullable
    public ICompoundTag read(InputStream is) throws IOException {
        return new CompoundWrapper(NbtIo.read((DataInput)new DataInputStream(is)));
    }

    @Override
    @Nullable
    public ICompoundTag fromSNBT(String snbt) throws IOException {
        try {
            return new CompoundWrapper(NbtUtils.snbtToStructure((String)snbt));
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    @Override
    public void write(ICompoundTag tag, Path path) throws IOException {
        NbtIo.write((CompoundTag)((CompoundTag)tag.unwrap()), (Path)path);
    }

    @Override
    public ICompoundTag emptyCompound() {
        return new CompoundWrapper(new CompoundTag());
    }

    public static class CompoundWrapper
    implements ICompoundTag {
        private final CompoundTag tag;

        public CompoundWrapper(CompoundTag tag) {
            this.tag = tag;
        }

        @Override
        public void put(String name, ITag value) {
            this.tag.put(name, (Tag)value.unwrap());
        }

        @Override
        public void putByte(String name, byte value) {
            this.tag.putByte(name, value);
        }

        @Override
        public void putShort(String name, short value) {
            this.tag.putShort(name, value);
        }

        @Override
        public void putInt(String name, int value) {
            this.tag.putInt(name, value);
        }

        @Override
        public void putLong(String name, long value) {
            this.tag.putLong(name, value);
        }

        @Override
        public void putUUID(String name, UUID value) {
            this.tag.putIntArray(name, CompoundWrapper.uuidToIntArray(value));
        }

        private static int[] uuidToIntArray(UUID uuid) {
            long most = uuid.getMostSignificantBits();
            long least = uuid.getLeastSignificantBits();
            return CompoundWrapper.leastMostToIntArray(most, least);
        }

        private static int[] leastMostToIntArray(long most, long least) {
            return new int[]{(int)(most >> 32), (int)most, (int)(least >> 32), (int)least};
        }

        private static UUID uuidFromIntArray(int[] uuidInts) {
            return new UUID((long)uuidInts[0] << 32 | (long)uuidInts[1] & 0xFFFFFFFFL, (long)uuidInts[2] << 32 | (long)uuidInts[3] & 0xFFFFFFFFL);
        }

        @Override
        public UUID getUUID(String name) {
            int[] ints = this.tag.getIntArray(name);
            if (ints.length == 4) {
                return CompoundWrapper.uuidFromIntArray(ints);
            }
            throw new IllegalArgumentException("Invalid UUID tag, Expected int array of length 4, found " + String.valueOf(ints));
        }

        @Override
        public boolean hasUUID(String name) {
            int[] ints = this.tag.getIntArray(name);
            return ints.length == 4;
        }

        @Override
        public void putFloat(String name, float value) {
            this.tag.putFloat(name, value);
        }

        @Override
        public void putDouble(String name, double value) {
            this.tag.putDouble(name, value);
        }

        @Override
        public void putString(String name, String value) {
            this.tag.putString(name, value);
        }

        @Override
        public void putByteArray(String name, byte[] value) {
            this.tag.putByteArray(name, value);
        }

        @Override
        public void putIntArray(String name, int[] value) {
            this.tag.putIntArray(name, value);
        }

        @Override
        public void putLongArray(String name, long[] value) {
            this.tag.putLongArray(name, value);
        }

        @Override
        public void putBoolean(String name, boolean value) {
            this.tag.putBoolean(name, value);
        }

        @Override
        public byte getTagType(String name) {
            return this.tag.getTagType(name);
        }

        @Override
        public boolean contains(String name) {
            return this.tag.contains(name);
        }

        @Override
        public boolean contains(String name, int type) {
            return this.tag.contains(name, type);
        }

        @Override
        public byte getByte(String name) {
            return this.tag.getByte(name);
        }

        @Override
        public short getShort(String name) {
            return this.tag.getShort(name);
        }

        @Override
        public int getInt(String name) {
            return this.tag.getInt(name);
        }

        @Override
        public long getLong(String name) {
            return this.tag.getLong(name);
        }

        @Override
        public float getFloat(String name) {
            return this.tag.getFloat(name);
        }

        @Override
        public double getDouble(String name) {
            return this.tag.getDouble(name);
        }

        @Override
        @NotNull
        public String getString(String name) {
            return this.tag.getString(name);
        }

        @Override
        public byte[] getByteArray(String name) {
            return this.tag.getByteArray(name);
        }

        @Override
        public int[] getIntArray(String name) {
            return this.tag.getIntArray(name);
        }

        @Override
        public long[] getLongArray(String name) {
            return this.tag.getLongArray(name);
        }

        @Override
        @NotNull
        public ICompoundTag getCompound(String name) {
            return new CompoundWrapper(this.tag.getCompound(name));
        }

        @Override
        public IListTag getList(String name, int type) {
            if (!this.tag.contains(name, 9)) {
                return null;
            }
            return new ListWrapper(this.tag.getList(name, type));
        }

        @Override
        public boolean getBoolean(String name) {
            return this.tag.getBoolean(name);
        }

        @Override
        public void remove(String name) {
            this.tag.remove(name);
        }

        public CompoundTag unwrap() {
            return this.tag;
        }

        public int hashCode() {
            return this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompoundTag) {
                return this.tag.equals(obj);
            }
            if (obj instanceof CompoundWrapper) {
                return this.tag.equals((Object)((CompoundWrapper)obj).tag);
            }
            return super.equals(obj);
        }
    }

    public static class ListWrapper
    implements IListTag {
        private final ListTag tag;

        public ListWrapper(ListTag tag) {
            this.tag = tag;
        }

        @Override
        public void remove(int index) {
            this.tag.remove(index);
        }

        @Override
        public boolean isEmpty() {
            return this.tag.size() == 0;
        }

        @Override
        public ICompoundTag getCompound(int index) {
            return new CompoundWrapper(this.tag.getCompound(index));
        }

        @Override
        @Nullable
        public IListTag getList(int index) {
            return new ListWrapper(this.tag.getList(index));
        }

        @Override
        public short getShort(int index) {
            return this.tag.getShort(index);
        }

        @Override
        public int getInt(int index) {
            return this.tag.getInt(index);
        }

        @Override
        public int[] getIntArray(int index) {
            return this.tag.getIntArray(index);
        }

        @Override
        public long[] getLongArray(int index) {
            return this.tag.getLongArray(index);
        }

        @Override
        public double getDouble(int index) {
            return this.tag.getDouble(index);
        }

        @Override
        public float getFloat(int index) {
            return this.tag.getFloat(index);
        }

        @Override
        public String getString(int index) {
            return this.tag.getString(index);
        }

        @Override
        public int size() {
            return this.tag.size();
        }

        @Override
        public void set(int index, ITag tag) {
            this.tag.set(index, (Tag)SneakyUtils.unsafeCast(tag.unwrap()));
        }

        @Override
        public void add(ITag tag) {
            this.tag.add((Object)((Tag)SneakyUtils.unsafeCast(tag.unwrap())));
        }

        public ListTag unwrap() {
            return this.tag;
        }
    }
}

