/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.grid.strategy;

import javax.annotation.Nonnull;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

class CursorItemHandler
implements IItemHandler {
    private final AbstractContainerMenu containerMenu;

    CursorItemHandler(AbstractContainerMenu containerMenu) {
        this.containerMenu = containerMenu;
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.containerMenu.getCarried();
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0) {
            return stack;
        }
        if (this.containerMenu.getCarried().isEmpty()) {
            return this.insertIntoEmptyCursor(stack, simulate);
        }
        if (!this.isSame(this.containerMenu.getCarried(), stack)) {
            return stack;
        }
        return this.insertIntoCursorWithExistingContent(stack, simulate);
    }

    private ItemStack insertIntoEmptyCursor(ItemStack itemStack, boolean simulate) {
        if (!simulate) {
            this.containerMenu.setCarried(itemStack);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack insertIntoCursorWithExistingContent(ItemStack itemStack, boolean simulate) {
        int spaceLeft = this.containerMenu.getCarried().getMaxStackSize() - this.containerMenu.getCarried().getCount();
        if (spaceLeft <= 0) {
            return itemStack;
        }
        int toInsert = Math.min(itemStack.getCount(), spaceLeft);
        int remainder = itemStack.getCount() - toInsert;
        if (!simulate) {
            this.containerMenu.getCarried().grow(toInsert);
        }
        return itemStack.copyWithCount(remainder);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        if (this.containerMenu.getCarried().isEmpty()) {
            return ItemStack.EMPTY;
        }
        int extracted = Math.min(this.containerMenu.getCarried().getCount(), amount);
        ItemStack extractedStack = this.containerMenu.getCarried().copyWithCount(extracted);
        if (!simulate) {
            this.containerMenu.getCarried().shrink(extracted);
        }
        return extractedStack;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return slot == 0;
    }

    private boolean isSame(ItemStack a, ItemStack b) {
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }
}

