/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.exporter;

import com.refinedmods.refinedstorage.api.network.impl.node.exporter.ExporterTransferStrategyImpl;
import com.refinedmods.refinedstorage.api.network.impl.node.exporter.MissingResourcesListeningExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.exporter.ExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.exporter.ExporterTransferQuotaProvider;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCacheImpl;
import com.refinedmods.refinedstorage.neoforge.storage.ItemHandlerInsertableStorage;
import java.util.function.ToLongFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;

public class ItemHandlerExporterTransferStrategyFactory
implements ExporterTransferStrategyFactory {
    @Override
    public Class<? extends ResourceKey> getResourceType() {
        return ItemResource.class;
    }

    @Override
    public ExporterTransferStrategy create(ServerLevel level, BlockPos pos, Direction direction, UpgradeState upgradeState, boolean fuzzyMode) {
        CapabilityCacheImpl coordinates = new CapabilityCacheImpl(level, pos, direction);
        ItemHandlerInsertableStorage destination = new ItemHandlerInsertableStorage(coordinates);
        ExporterTransferStrategy strategy = this.create(fuzzyMode, destination, new ExporterTransferQuotaProvider(1L, upgradeState, destination::getAmount, true));
        if (upgradeState.has(Items.INSTANCE.getAutocraftingUpgrade())) {
            return new MissingResourcesListeningExporterTransferStrategy(strategy, MissingResourcesListeningExporterTransferStrategy.OnMissingResources.scheduleAutocrafting(new ExporterTransferQuotaProvider(1L, upgradeState, destination::getAmount, false)));
        }
        return strategy;
    }

    private ExporterTransferStrategy create(boolean fuzzyMode, ItemHandlerInsertableStorage destination, ToLongFunction<ResourceKey> transferQuotaProvider) {
        if (fuzzyMode) {
            return new ExporterTransferStrategyImpl(destination, transferQuotaProvider, FuzzyRootStorage.expander());
        }
        return new ExporterTransferStrategyImpl(destination, transferQuotaProvider);
    }
}

