/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.networking.NetworkReceiverBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkReceiverKey;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class NetworkCardItem
extends Item {
    private static final MutableComponent UNBOUND_HELP = IdentifierUtil.createTranslation("item", "network_card.unbound_help");
    private static final MutableComponent BOUND_HELP = IdentifierUtil.createTranslation("item", "network_card.bound_help");
    private static final MutableComponent UNBOUND = IdentifierUtil.createTranslation("item", "network_card.unbound").withStyle(ChatFormatting.RED);

    public NetworkCardItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getLevel().isClientSide() || ctx.getPlayer() == null) {
            return InteractionResult.CONSUME;
        }
        BlockPos pos = ctx.getClickedPos();
        BlockState blockState = ctx.getLevel().getBlockState(pos);
        if (!(blockState.getBlock() instanceof NetworkReceiverBlock)) {
            return InteractionResult.CONSUME;
        }
        ResourceKey dimension = ctx.getLevel().dimension();
        GlobalPos location = GlobalPos.of((ResourceKey)dimension, (BlockPos)pos);
        ctx.getItemInHand().set(DataComponents.INSTANCE.getNetworkLocation(), (Object)location);
        ctx.getPlayer().sendSystemMessage((Component)IdentifierUtil.createTranslation("item", "network_card.bound", pos.getX(), pos.getY(), pos.getZ(), NetworkReceiverKey.getDimensionName((ResourceKey<Level>)dimension).withStyle(ChatFormatting.YELLOW)));
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isCrouching()) {
            if (!level.isClientSide()) {
                player.sendSystemMessage((Component)IdentifierUtil.createTranslation("item", "network_card.unbound"));
            }
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)new ItemStack((ItemLike)this));
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        super.appendHoverText(stack, context, lines, flag);
        this.getLocation(stack).ifPresentOrElse(location -> lines.add((Component)IdentifierUtil.createTranslation("item", "network_card.bound", location.pos().getX(), location.pos().getY(), location.pos().getZ(), NetworkReceiverKey.getDimensionName((ResourceKey<Level>)location.dimension()).withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GRAY)), () -> lines.add((Component)UNBOUND));
    }

    Optional<GlobalPos> getLocation(ItemStack stack) {
        return Optional.ofNullable((GlobalPos)stack.get(DataComponents.INSTANCE.getNetworkLocation()));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent((Component)(this.isActive(stack) ? BOUND_HELP : UNBOUND_HELP)));
    }

    boolean isActive(ItemStack stack) {
        return stack.has(DataComponents.INSTANCE.getNetworkLocation());
    }
}

