/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzyGridOperations
implements GridOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(FuzzyGridOperations.class);
    private static final Component INACCURATE_EXTRACTION = IdentifierUtil.createTranslation("gui", "grid.inaccurate_extraction");
    private static final Component CHECK_CHAT_FOR_MORE_DETAILS = IdentifierUtil.createTranslation("gui", "grid.inaccurate_extraction.check_chat_for_more_details");
    private static final Component READ_MORE = IdentifierUtil.createTranslation("gui", "grid.inaccurate_extraction.read_more").setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://refinedmods.com/refined-storage/troubleshooting/inaccurate-extraction.html")).withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)));
    private final ServerPlayer player;
    private final FuzzyRootStorage fuzzyRootStorage;
    private final GridOperations delegate;

    public FuzzyGridOperations(ServerPlayer player, FuzzyRootStorage fuzzyRootStorage, GridOperations delegate) {
        this.player = player;
        this.fuzzyRootStorage = fuzzyRootStorage;
        this.delegate = delegate;
    }

    @Override
    public boolean extract(ResourceKey resource, GridExtractMode extractMode, InsertableStorage destination) {
        boolean success = this.delegate.extract(resource, extractMode, destination);
        if (!success) {
            LOGGER.warn("Failed to extract resource in Grid: {}", (Object)resource);
            if (resource instanceof ItemResource) {
                ItemResource itemResource = (ItemResource)resource;
                itemResource.components().entrySet().forEach(e -> {
                    DataComponentType componentType = (DataComponentType)e.getKey();
                    ResourceLocation key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)componentType);
                    LOGGER.warn("Component {} = {}", (Object)key, e.getValue());
                });
            }
        }
        if (!success && this.tryFuzzyExtractBecauseModHasUnstableDataComponentEquality(resource, extractMode, destination)) {
            return true;
        }
        return success;
    }

    private boolean tryFuzzyExtractBecauseModHasUnstableDataComponentEquality(ResourceKey resource, GridExtractMode extractMode, InsertableStorage destination) {
        for (ResourceKey fuzzyResource : this.fuzzyRootStorage.getFuzzy(resource)) {
            if (!this.delegate.extract(fuzzyResource, extractMode, destination)) continue;
            String modId = FuzzyGridOperations.getModId(resource);
            MutableComponent baseMessage = IdentifierUtil.createTranslation("gui", "grid.inaccurate_extraction.due_to_bug_in_other_mod_wrong_resource_maybe_extracted", modId).append(" ");
            RefinedStorageApi.INSTANCE.sendMessage(this.player, INACCURATE_EXTRACTION, (Component)baseMessage.copy().append(CHECK_CHAT_FOR_MORE_DETAILS));
            this.player.sendSystemMessage((Component)baseMessage.copy().append(READ_MORE));
            return true;
        }
        return false;
    }

    private static String getModId(ResourceKey resource) {
        if (resource instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resource;
            return BuiltInRegistries.ITEM.getKey((Object)itemResource.item()).getNamespace();
        }
        if (resource instanceof FluidResource) {
            FluidResource fluidResource = (FluidResource)resource;
            return BuiltInRegistries.FLUID.getKey((Object)fluidResource.fluid()).getNamespace();
        }
        return "<unknown>";
    }

    @Override
    public boolean insert(ResourceKey resource, GridInsertMode insertMode, ExtractableStorage source) {
        return this.delegate.insert(resource, insertMode, source);
    }
}

