/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.detector;

import com.refinedmods.refinedstorage.api.network.impl.node.detector.AbstractDetectorAmountStrategy;
import com.refinedmods.refinedstorage.api.network.impl.node.detector.DetectorAmountStrategyImpl;
import com.refinedmods.refinedstorage.api.network.impl.node.detector.DetectorMode;
import com.refinedmods.refinedstorage.api.network.impl.node.detector.DetectorNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.detector.DetectorBlock;
import com.refinedmods.refinedstorage.common.detector.DetectorConnectionStrategy;
import com.refinedmods.refinedstorage.common.detector.DetectorContainerMenu;
import com.refinedmods.refinedstorage.common.detector.DetectorModeSettings;
import com.refinedmods.refinedstorage.common.detector.FuzzyDetectorAmountStrategy;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.containermenu.SingleAmountData;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectorBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<DetectorNetworkNode>
implements NetworkNodeExtendedMenuProvider<SingleAmountData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetectorBlockEntity.class);
    private static final int POWERED_CHANGE_TICK_RATE = 20;
    private static final String TAG_AMOUNT = "amount";
    private static final String TAG_MODE = "mode";
    private final FilterWithFuzzyMode filter;
    private int poweredChangeTicks;
    private double amount;

    public DetectorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getDetector(), pos, state, new DetectorNetworkNode(Platform.INSTANCE.getConfig().getDetector().getEnergyUsage()));
        ResourceContainer resourceContainer = ResourceContainerImpl.createForFilter(1);
        this.filter = FilterWithFuzzyMode.createAndListenForFilters(resourceContainer, () -> {
            this.propagateAmount();
            this.setChanged();
        }, filters -> ((DetectorNetworkNode)this.mainNetworkNode).setConfiguredResource(filters.isEmpty() ? null : (ResourceKey)filters.getFirst()));
        this.initialize();
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(DetectorNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, networkNode).connectionStrategy(new DetectorConnectionStrategy(() -> ((DetectorBlockEntity)this).getBlockState(), this.getBlockPos())).build();
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
        tag.putDouble(TAG_AMOUNT, this.amount);
        tag.putInt(TAG_MODE, DetectorModeSettings.getDetectorMode(((DetectorNetworkNode)this.mainNetworkNode).getMode()));
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
        if (tag.contains(TAG_AMOUNT)) {
            this.amount = tag.getDouble(TAG_AMOUNT);
        }
        if (tag.contains(TAG_MODE)) {
            ((DetectorNetworkNode)this.mainNetworkNode).setMode(DetectorModeSettings.getDetectorMode(tag.getInt(TAG_MODE)));
        }
        this.initialize();
        this.propagateAmount();
    }

    void setAmount(double amount) {
        this.amount = amount;
        this.propagateAmount();
        this.setChanged();
    }

    private void propagateAmount() {
        PlatformResourceKey configuredResource = this.filter.getFilterContainer().getResource(0);
        long normalizedAmount = configuredResource == null ? (long)this.amount : configuredResource.getResourceType().normalizeAmount(this.amount);
        LOGGER.debug("Updating detector amount of {} normalized as {}", (Object)this.amount, (Object)normalizedAmount);
        ((DetectorNetworkNode)this.mainNetworkNode).setAmount(normalizedAmount);
    }

    void setConfiguredResource(ResourceKey configuredResource) {
        ((DetectorNetworkNode)this.mainNetworkNode).setConfiguredResource(configuredResource);
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        this.initialize();
    }

    void setMode(DetectorMode mode) {
        ((DetectorNetworkNode)this.mainNetworkNode).setMode(mode);
        this.setChanged();
    }

    DetectorMode getMode() {
        return ((DetectorNetworkNode)this.mainNetworkNode).getMode();
    }

    private void initialize() {
        DetectorAmountStrategyImpl defaultStrategy = new DetectorAmountStrategyImpl();
        AbstractDetectorAmountStrategy strategy = this.isFuzzyMode() ? new FuzzyDetectorAmountStrategy(defaultStrategy) : defaultStrategy;
        ((DetectorNetworkNode)this.mainNetworkNode).setAmountStrategy(strategy);
    }

    @Override
    public SingleAmountData getMenuData() {
        return new SingleAmountData(Optional.empty(), this.amount, ResourceContainerData.of(this.filter.getFilterContainer()));
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, SingleAmountData> getMenuCodec() {
        return SingleAmountData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.DETECTOR);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new DetectorContainerMenu(syncId, player, this, this.filter.getFilterContainer());
    }

    @Override
    public void updateActiveness(BlockState state, @Nullable BooleanProperty activenessProperty) {
        boolean needToUpdatePowered;
        super.updateActiveness(state, activenessProperty);
        boolean powered = ((DetectorNetworkNode)this.mainNetworkNode).isActive() && ((DetectorNetworkNode)this.mainNetworkNode).isActivated();
        boolean bl = needToUpdatePowered = (Boolean)state.getValue((Property)DetectorBlock.POWERED) != powered;
        if (this.level != null && needToUpdatePowered && this.poweredChangeTicks++ % 20 == 0) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)DetectorBlock.POWERED, (Comparable)Boolean.valueOf(powered)));
            this.poweredChangeTicks = 0;
        }
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }

    @Override
    protected boolean hasRedstoneMode() {
        return false;
    }
}

