/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategy;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

class BlockBreakDestructorStrategy
implements DestructorStrategy {
    private final ServerLevel level;
    private final BlockPos pos;
    private final Direction direction;
    private final ItemStack tool;

    BlockBreakDestructorStrategy(ServerLevel level, BlockPos pos, Direction direction, ItemStack tool) {
        this.level = level;
        this.pos = pos;
        this.direction = direction;
        this.tool = tool;
    }

    @Override
    public boolean apply(Filter filter, Actor actor, Supplier<Network> networkProvider, Player player) {
        if (!this.level.isLoaded(this.pos)) {
            return false;
        }
        BlockState blockState = this.level.getBlockState(this.pos);
        Block block = blockState.getBlock();
        if (BlockBreakDestructorStrategy.isFastExit(blockState) || (double)blockState.getDestroySpeed((BlockGetter)this.level, this.pos) == -1.0 || !this.isAllowed(player, filter, blockState, block) || !Platform.INSTANCE.canBreakBlock((Level)this.level, this.pos, blockState, player)) {
            return false;
        }
        List drops = Block.getDrops((BlockState)blockState, (ServerLevel)this.level, (BlockPos)this.pos, (BlockEntity)this.level.getBlockEntity(this.pos), (Entity)player, (ItemStack)this.tool);
        if (!this.insertDrops(actor, drops, BlockBreakDestructorStrategy.getRootStorage(networkProvider), Action.SIMULATE)) {
            return false;
        }
        block.playerWillDestroy((Level)this.level, this.pos, blockState, player);
        this.level.removeBlock(this.pos, false);
        this.insertDrops(actor, drops, BlockBreakDestructorStrategy.getRootStorage(networkProvider), Action.EXECUTE);
        return true;
    }

    private static RootStorage getRootStorage(Supplier<Network> network) {
        return network.get().getComponent(StorageNetworkComponent.class);
    }

    private static boolean isFastExit(BlockState blockState) {
        return blockState.isAir() || blockState.getBlock() instanceof LiquidBlock;
    }

    private boolean isAllowed(Player actingPlayer, Filter filter, BlockState state, Block block) {
        ItemStack blockAsStack = Platform.INSTANCE.getBlockAsItemStack(block, state, this.direction, (LevelReader)this.level, this.pos, actingPlayer);
        if (blockAsStack.isEmpty()) {
            return false;
        }
        ItemResource blockAsResource = ItemResource.ofItemStack(blockAsStack);
        return filter.isAllowed(blockAsResource);
    }

    private boolean insertDrops(Actor actor, List<ItemStack> drops, RootStorage storage, Action action) {
        for (ItemStack drop : drops) {
            boolean didWeDisconnectStorageInTheProcessOfRemovingABlock;
            ItemResource resource = ItemResource.ofItemStack(drop);
            boolean didNotInsertCompletely = storage.insert(resource, drop.getCount(), action, actor) != (long)drop.getCount();
            if (!didNotInsertCompletely) continue;
            boolean bl = didWeDisconnectStorageInTheProcessOfRemovingABlock = action == Action.EXECUTE;
            if (didWeDisconnectStorageInTheProcessOfRemovingABlock) {
                Containers.dropItemStack((Level)this.level, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), (ItemStack)drop);
                continue;
            }
            return false;
        }
        return true;
    }
}

