/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.common.api.autocrafting.PatternOutputRenderingScreen;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderItem;
import com.refinedmods.refinedstorage.common.util.ClientPlatformUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class PatternRendering {
    private PatternRendering() {
    }

    public static boolean canDisplayOutput(ItemStack stack) {
        if (!(stack.getItem() instanceof PatternProviderItem)) {
            return false;
        }
        if (Screen.hasShiftDown()) {
            return true;
        }
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof PatternOutputRenderingScreen)) {
            return false;
        }
        PatternOutputRenderingScreen patternOutputRenderingScreen = (PatternOutputRenderingScreen)screen;
        return patternOutputRenderingScreen.canDisplayOutput(stack);
    }

    public static Optional<ItemStack> getOutput(ItemStack stack) {
        Level level = ClientPlatformUtil.getClientLevel();
        if (level == null) {
            return Optional.empty();
        }
        Item item = stack.getItem();
        if (item instanceof PatternProviderItem) {
            PatternProviderItem patternProviderItem = (PatternProviderItem)item;
            return patternProviderItem.getOutput(stack, level);
        }
        return Optional.empty();
    }
}

