/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.preview;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewItem;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewType;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PreviewBuilder {
    private final Map<ResourceKey, MutablePreviewItem> items;
    private List<ResourceAmount> outputsOfPatternWithCycle = Collections.emptyList();
    private boolean missing;

    private PreviewBuilder() {
        this.items = new LinkedHashMap<ResourceKey, MutablePreviewItem>();
    }

    private PreviewBuilder(int size) {
        this.items = LinkedHashMap.newLinkedHashMap(size);
    }

    public static PreviewBuilder create() {
        return new PreviewBuilder();
    }

    private MutablePreviewItem get(ResourceKey resource) {
        return this.items.computeIfAbsent(resource, key -> new MutablePreviewItem());
    }

    public PreviewBuilder withPatternWithCycle(Pattern pattern) {
        this.outputsOfPatternWithCycle = pattern.layout().outputs();
        return this;
    }

    public PreviewBuilder addAvailable(ResourceKey resource, long amount) {
        CoreValidations.validateLargerThanZero(amount, "Available amount must be larger than 0");
        this.get((ResourceKey)resource).available += amount;
        return this;
    }

    public PreviewBuilder addMissing(ResourceKey resource, long amount) {
        CoreValidations.validateLargerThanZero(amount, "Missing amount must be larger than 0");
        this.get((ResourceKey)resource).missing += amount;
        this.missing = true;
        return this;
    }

    public PreviewBuilder addToCraft(ResourceKey resource, long amount) {
        CoreValidations.validateLargerThanZero(amount, "To craft amount must be larger than 0");
        this.get((ResourceKey)resource).toCraft += amount;
        return this;
    }

    public PreviewBuilder copy() {
        PreviewBuilder copy = new PreviewBuilder(this.items.size());
        for (Map.Entry<ResourceKey, MutablePreviewItem> entry : this.items.entrySet()) {
            MutablePreviewItem item = entry.getValue();
            copy.items.put(entry.getKey(), item.copy());
        }
        copy.outputsOfPatternWithCycle = this.outputsOfPatternWithCycle;
        copy.missing = this.missing;
        return copy;
    }

    public Preview build() {
        return new Preview(this.getType(), this.items.entrySet().stream().map(entry -> ((MutablePreviewItem)entry.getValue()).toPreviewItem((ResourceKey)entry.getKey())).toList(), this.outputsOfPatternWithCycle);
    }

    private PreviewType getType() {
        if (!this.outputsOfPatternWithCycle.isEmpty()) {
            return PreviewType.CYCLE_DETECTED;
        }
        return this.missing ? PreviewType.MISSING_RESOURCES : PreviewType.SUCCESS;
    }

    private static class MutablePreviewItem {
        private long available;
        private long missing;
        private long toCraft;

        private MutablePreviewItem() {
        }

        private PreviewItem toPreviewItem(ResourceKey resource) {
            return new PreviewItem(resource, this.available, this.missing, this.toCraft);
        }

        private MutablePreviewItem copy() {
            MutablePreviewItem copy = new MutablePreviewItem();
            copy.available = this.available;
            copy.missing = this.missing;
            copy.toCraft = this.toCraft;
            return copy;
        }
    }
}

