/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.calculation;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.Amount;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.NumberOverflowDuringCalculationException;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.LazyCopyMutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;

class CraftingState {
    private final MutableResourceList storage;
    private final MutableResourceList internalStorage;

    private CraftingState(MutableResourceList storage, MutableResourceList internalStorage) {
        this.storage = storage;
        this.internalStorage = internalStorage;
    }

    void extractFromInternalStorage(ResourceKey resource, long amount) {
        this.internalStorage.remove(resource, amount);
    }

    void extractFromStorage(ResourceKey resource, long amount) {
        this.storage.remove(resource, amount);
    }

    void addOutputsToInternalStorage(Pattern pattern, Amount amount) {
        pattern.layout().outputs().forEach(output -> this.addOutputToInternalStorage(amount, (ResourceAmount)output));
    }

    private void addOutputToInternalStorage(Amount amount, ResourceAmount output) {
        long totalAmount = output.amount() * amount.iterations();
        if (totalAmount < 0L) {
            throw new NumberOverflowDuringCalculationException();
        }
        this.internalStorage.add(output.resource(), totalAmount);
    }

    CraftingState copy() {
        return new CraftingState(this.storage.copy(), this.internalStorage.copy());
    }

    static CraftingState of(RootStorage rootStorage) {
        MutableResourceListImpl storage = MutableResourceListImpl.create();
        rootStorage.getAll().forEach(storage::add);
        return new CraftingState(LazyCopyMutableResourceList.create(storage), MutableResourceListImpl.create());
    }

    ResourceState getResource(ResourceKey resource) {
        return new ResourceState(resource, this.storage.get(resource), this.internalStorage.get(resource));
    }

    record ResourceState(ResourceKey resource, long inStorage, long inInternalStorage) implements Comparable<ResourceState>
    {
        boolean isInStorage() {
            return this.inStorage > 0L;
        }

        boolean isInInternalStorage() {
            return this.inInternalStorage > 0L;
        }

        @Override
        public int compareTo(ResourceState o) {
            int storage = Long.compare(o.inStorage, this.inStorage);
            if (storage == 0) {
                return Long.compare(o.inInternalStorage, this.inInternalStorage);
            }
            return storage;
        }
    }
}

