/*
 * Decompiled with CFR 0.152.
 */
package com.serpenssolida.createtransmission.content.chain;

import com.serpenssolida.createtransmission.CTBlockEntities;
import com.serpenssolida.createtransmission.CTBlocks;
import com.serpenssolida.createtransmission.CTShapes;
import com.serpenssolida.createtransmission.content.chain.TransmissionChainBlockEntity;
import com.serpenssolida.createtransmission.content.chain.TransmissionChainHelpers;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTransmissionChainBlock
extends KineticBlock
implements IBE<TransmissionChainBlockEntity>,
ProperWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = EnumProperty.create((String)"facing", Direction.class);
    public static final EnumProperty<TransmissionChainHelpers.ConnectionType> CONNECTION_TYPE = EnumProperty.create((String)"connection_type", TransmissionChainHelpers.ConnectionType.class);
    public static final EnumProperty<TransmissionChainHelpers.ChainSide> CONNECTION_SIDE = EnumProperty.create((String)"connection_side", TransmissionChainHelpers.ChainSide.class);

    protected AbstractTransmissionChainBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(CONNECTION_TYPE, (Comparable)((Object)TransmissionChainHelpers.ConnectionType.NONE))).setValue(CONNECTION_SIDE, (Comparable)((Object)TransmissionChainHelpers.ChainSide.RIGHT))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING, CONNECTION_TYPE, CONNECTION_SIDE, WATERLOGGED}));
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        return List.of(new ItemStack((ItemLike)CTBlocks.TRANSMISSION_CHAIN.get()));
    }

    protected ItemInteractionResult useItemOn(ItemStack item, BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult ray) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.getValue(FACING);
        BlockPos otherPos = pos.offset(facing.getNormal());
        BlockEntity otherEntity = world.getBlockEntity(otherPos);
        if (otherEntity instanceof BeltBlockEntity) {
            BeltBlockEntity beltEntity = (BeltBlockEntity)otherEntity;
            BeltBlock beltBlock = (BeltBlock)beltEntity.getBlockState().getBlock();
            return beltBlock.hasShaftTowards(world, otherPos, beltEntity.getBlockState(), facing.getOpposite());
        }
        return false;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        TransmissionChainHelpers.ChainSide side = AbstractTransmissionChainBlock.isConnected(state) ? (TransmissionChainHelpers.ChainSide)((Object)state.getValue(CONNECTION_SIDE)) : TransmissionChainHelpers.ChainSide.TOP;
        TransmissionChainHelpers.ChainConnection nextAvailableConnection = AbstractTransmissionChainBlock.findFirstConnection((LevelAccessor)context.getLevel(), context.getClickedPos(), state, TransmissionChainHelpers.ChainSide.valuesFrom(side, false));
        if (nextAvailableConnection.side() != null) {
            state = (BlockState)state.setValue(CONNECTION_SIDE, (Comparable)((Object)nextAvailableConnection.side()));
        }
        state = (BlockState)state.setValue(CONNECTION_TYPE, (Comparable)((Object)nextAvailableConnection.type()));
        KineticBlockEntity.switchToBlockState((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (BlockState)state);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        TransmissionChainHelpers.ChainConnection connection = AbstractTransmissionChainBlock.getConnection(state);
        Direction facing = (Direction)state.getValue(FACING);
        if (connection.side() == null) {
            return CTShapes.CHAIN.get(facing);
        }
        if (connection.type() == TransmissionChainHelpers.ConnectionType.CHAIN) {
            return switch (connection.side()) {
                default -> throw new MatchException(null, null);
                case TransmissionChainHelpers.ChainSide.TOP -> CTShapes.CHAIN_CONNECTED_TOP.get(facing);
                case TransmissionChainHelpers.ChainSide.RIGHT -> CTShapes.CHAIN_CONNECTED_RIGHT.get(facing);
                case TransmissionChainHelpers.ChainSide.BOTTOM -> CTShapes.CHAIN_CONNECTED_BOTTOM.get(facing);
                case TransmissionChainHelpers.ChainSide.LEFT -> CTShapes.CHAIN_CONNECTED_LEFT.get(facing);
            };
        }
        if (connection.type() == TransmissionChainHelpers.ConnectionType.BELT) {
            return switch (connection.side()) {
                default -> throw new MatchException(null, null);
                case TransmissionChainHelpers.ChainSide.TOP -> CTShapes.CHAIN_BELT_TOP.get(facing);
                case TransmissionChainHelpers.ChainSide.RIGHT -> CTShapes.CHAIN_BELT_RIGHT.get(facing);
                case TransmissionChainHelpers.ChainSide.BOTTOM -> CTShapes.CHAIN_BELT_BOTTOM.get(facing);
                case TransmissionChainHelpers.ChainSide.LEFT -> CTShapes.CHAIN_BELT_LEFT.get(facing);
            };
        }
        return CTShapes.CHAIN.get(facing);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPos = context.getClickedPos();
        Direction facing = context.getClickedFace().getOpposite();
        BlockState state = (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)facing);
        state = this.withWater(state, context);
        return this.updateState(state, clickedPos, (LevelAccessor)context.getLevel());
    }

    public BlockState updateShape(BlockState state, Direction face, BlockState neighbour, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (!this.canSurvive(state, (LevelReader)world, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState newState = this.updateState(state, currentPos, world);
        this.updateWater(world, newState, currentPos);
        return newState;
    }

    private BlockState updateState(BlockState state, BlockPos pos, LevelAccessor world) {
        boolean wasConnected = AbstractTransmissionChainBlock.isConnected(state);
        if (wasConnected) {
            TransmissionChainHelpers.ChainConnection oldConnection = AbstractTransmissionChainBlock.getConnection(state);
            TransmissionChainHelpers.ConnectionType connection = AbstractTransmissionChainBlock.queryWorldForConnection(world, pos, state, oldConnection.side());
            if (connection == TransmissionChainHelpers.ConnectionType.NONE) {
                state = (BlockState)state.setValue(CONNECTION_TYPE, (Comparable)((Object)connection));
                state = (BlockState)state.setValue(CONNECTION_SIDE, (Comparable)((Object)oldConnection.side()));
            }
            return state;
        }
        TransmissionChainHelpers.ChainConnection firstConnection = AbstractTransmissionChainBlock.findFirstConnection(world, pos, state);
        if (firstConnection.side() != null && firstConnection.type() != TransmissionChainHelpers.ConnectionType.NONE) {
            state = (BlockState)state.setValue(CONNECTION_TYPE, (Comparable)((Object)firstConnection.type()));
            state = (BlockState)state.setValue(CONNECTION_SIDE, (Comparable)((Object)firstConnection.side()));
        }
        return state;
    }

    private static TransmissionChainHelpers.ChainConnection findFirstConnection(LevelAccessor world, BlockPos pos, BlockState state) {
        return AbstractTransmissionChainBlock.findFirstConnection(world, pos, state, TransmissionChainHelpers.ChainSide.values());
    }

    private static TransmissionChainHelpers.ChainConnection findFirstConnection(LevelAccessor world, BlockPos pos, BlockState state, TransmissionChainHelpers.ChainSide[] sides) {
        for (TransmissionChainHelpers.ChainSide side : sides) {
            TransmissionChainHelpers.ConnectionType connection = AbstractTransmissionChainBlock.queryWorldForConnection(world, pos, state, side);
            if (connection == TransmissionChainHelpers.ConnectionType.NONE) continue;
            return new TransmissionChainHelpers.ChainConnection(side, connection);
        }
        return new TransmissionChainHelpers.ChainConnection(null, TransmissionChainHelpers.ConnectionType.NONE);
    }

    private static TransmissionChainHelpers.ConnectionType queryWorldForConnection(LevelAccessor world, BlockPos pos, BlockState state, TransmissionChainHelpers.ChainSide side) {
        Direction directionBeltToChain;
        BeltBlock belt;
        boolean hasShaftTowards;
        TransmissionChainHelpers.ChainDirection facing = TransmissionChainHelpers.ChainDirection.of((Direction)state.getValue(FACING));
        BlockPos neighbourPos = pos.offset(facing.getDirectionFromSide(side).getNormal());
        BlockEntity neighbourEntity = world.getBlockEntity(neighbourPos);
        if (neighbourEntity == null) {
            return TransmissionChainHelpers.ConnectionType.NONE;
        }
        BlockState neighbourState = neighbourEntity.getBlockState();
        if (neighbourEntity instanceof TransmissionChainBlockEntity) {
            boolean isConnectionAvailable;
            TransmissionChainBlockEntity chainEntity = (TransmissionChainBlockEntity)neighbourEntity;
            TransmissionChainHelpers.ChainConnection otherConnection = AbstractTransmissionChainBlock.getConnection(neighbourState);
            boolean isConnectionValid = chainEntity.isConnected() && otherConnection.type() == TransmissionChainHelpers.ConnectionType.CHAIN && TransmissionChainHelpers.ChainSide.opposite(otherConnection.side()) == side;
            boolean bl = isConnectionAvailable = !chainEntity.isConnected() && otherConnection.type() == TransmissionChainHelpers.ConnectionType.NONE;
            if (facing.direction == neighbourState.getValue(FACING) && (isConnectionValid || isConnectionAvailable)) {
                return TransmissionChainHelpers.ConnectionType.CHAIN;
            }
        } else if (neighbourEntity instanceof BeltBlockEntity && (hasShaftTowards = (belt = (BeltBlock)neighbourState.getBlock()).hasShaftTowards((LevelReader)world, neighbourPos, neighbourState, directionBeltToChain = facing.getDirectionFromSide(side).getOpposite()))) {
            return TransmissionChainHelpers.ConnectionType.BELT;
        }
        return TransmissionChainHelpers.ConnectionType.NONE;
    }

    public static TransmissionChainHelpers.ChainConnection getConnection(BlockState state) {
        if (!(state.getBlock() instanceof AbstractTransmissionChainBlock)) {
            return new TransmissionChainHelpers.ChainConnection(null, TransmissionChainHelpers.ConnectionType.NONE);
        }
        TransmissionChainHelpers.ConnectionType connectionType = (TransmissionChainHelpers.ConnectionType)((Object)state.getValue(CONNECTION_TYPE));
        TransmissionChainHelpers.ChainSide side = (TransmissionChainHelpers.ChainSide)((Object)state.getValue(CONNECTION_SIDE));
        return new TransmissionChainHelpers.ChainConnection(connectionType != TransmissionChainHelpers.ConnectionType.NONE ? side : null, connectionType);
    }

    public static boolean isConnected(BlockState state) {
        if (!(state.getBlock() instanceof AbstractTransmissionChainBlock)) {
            return false;
        }
        return state.getValue(CONNECTION_TYPE) != TransmissionChainHelpers.ConnectionType.NONE;
    }

    public static boolean isSideConnected(BlockState state, TransmissionChainHelpers.ChainSide side) {
        if (!(state.getBlock() instanceof AbstractTransmissionChainBlock)) {
            return false;
        }
        return state.getValue(CONNECTION_SIDE) == side;
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        TransmissionChainHelpers.ChainConnection oldConnection = AbstractTransmissionChainBlock.getConnection(oldState);
        TransmissionChainHelpers.ChainConnection newConnection = AbstractTransmissionChainBlock.getConnection(newState);
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldConnection.equals(newConnection);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.getValue(FACING);
        if (AbstractTransmissionChainBlock.isConnected(state = (BlockState)state.setValue(FACING, (Comparable)mirror.mirror(facing)))) {
            state = this.mirrorSide(state, mirror);
        }
        return state;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        Direction facing = (Direction)state.getValue(FACING);
        if (rotation == Rotation.NONE) {
            return state;
        }
        if (facing.getAxis().isVertical()) {
            return AbstractTransmissionChainBlock.rotateSide(state, rotation == Rotation.CLOCKWISE_180 ? rotation : rotation.getRotated(Rotation.CLOCKWISE_180));
        }
        state = (BlockState)state.setValue(FACING, (Comparable)rotation.rotate(facing));
        return state;
    }

    private BlockState mirrorSide(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.getValue(FACING);
        TransmissionChainHelpers.ChainSide side = (TransmissionChainHelpers.ChainSide)((Object)state.getValue(CONNECTION_SIDE));
        if (mirror == Mirror.NONE) {
            return state;
        }
        if (facing.getAxis().isHorizontal()) {
            if (side == TransmissionChainHelpers.ChainSide.LEFT || side == TransmissionChainHelpers.ChainSide.RIGHT) {
                return (BlockState)state.setValue(CONNECTION_SIDE, (Comparable)((Object)TransmissionChainHelpers.ChainSide.opposite(side)));
            }
            return state;
        }
        if (mirror == Mirror.FRONT_BACK && (side == TransmissionChainHelpers.ChainSide.LEFT || side == TransmissionChainHelpers.ChainSide.RIGHT)) {
            state = (BlockState)state.setValue(CONNECTION_SIDE, (Comparable)((Object)TransmissionChainHelpers.ChainSide.opposite(side)));
        } else if (mirror == Mirror.LEFT_RIGHT && (side == TransmissionChainHelpers.ChainSide.TOP || side == TransmissionChainHelpers.ChainSide.BOTTOM)) {
            state = (BlockState)state.setValue(CONNECTION_SIDE, (Comparable)((Object)TransmissionChainHelpers.ChainSide.opposite(side)));
        }
        return state;
    }

    private static BlockState rotateSide(BlockState state, Rotation rotation) {
        Direction facing = (Direction)state.getValue(FACING);
        TransmissionChainHelpers.ChainSide side = (TransmissionChainHelpers.ChainSide)((Object)state.getValue(CONNECTION_SIDE));
        if (facing == Direction.DOWN && rotation != Rotation.CLOCKWISE_180) {
            rotation = rotation == Rotation.CLOCKWISE_90 ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        }
        state = (BlockState)state.setValue(CONNECTION_SIDE, (Comparable)((Object)TransmissionChainHelpers.ChainSide.rotate(side, rotation)));
        return state;
    }

    public FluidState getFluidState(BlockState blockState) {
        return this.fluidState(blockState);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction direction) {
        TransmissionChainHelpers.ChainConnection connection;
        TransmissionChainHelpers.ChainDirection facing = TransmissionChainHelpers.ChainDirection.of((Direction)state.getValue(FACING));
        if (facing.direction == direction) {
            return true;
        }
        TransmissionChainHelpers.ChainSide side = facing.getSideFromDirection(direction);
        return side == (connection = AbstractTransmissionChainBlock.getConnection(state)).side() && connection.type() != TransmissionChainHelpers.ConnectionType.NONE;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(FACING)).getAxis();
    }

    public Class<TransmissionChainBlockEntity> getBlockEntityClass() {
        return TransmissionChainBlockEntity.class;
    }

    public BlockEntityType<? extends TransmissionChainBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CTBlockEntities.TRANSMISSION_CHAIN.get();
    }
}

