/*
 * Decompiled with CFR 0.152.
 */
package uppers.tiles;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import uppers.blocks.UpperBlock;
import uppers.tiles.IUpper;
import uppers.tiles.UpperBlockEntity;

public class InventoryCodeHooksTweaked {
    @Nullable
    public static Boolean extractHook(Level level, IUpper dest) {
        return InventoryCodeHooksTweaked.getSourceItemHandler(level, dest).map(itemHandlerResult -> {
            IItemHandler handler = (IItemHandler)itemHandlerResult.getKey();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extractItem = handler.extractItem(i, 1, true);
                if (extractItem.isEmpty()) continue;
                for (int j = 0; j < dest.getContainerSize(); ++j) {
                    ItemStack destStack = dest.getItem(j);
                    if (!dest.canPlaceItem(j, extractItem) || !destStack.isEmpty() && (destStack.getCount() >= destStack.getMaxStackSize() || destStack.getCount() >= dest.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)extractItem, (ItemStack)destStack))) continue;
                    extractItem = handler.extractItem(i, 1, false);
                    if (destStack.isEmpty()) {
                        dest.setItem(j, extractItem);
                    } else {
                        destStack.grow(1);
                        dest.setItem(j, destStack);
                    }
                    dest.setChanged();
                    return true;
                }
            }
            return false;
        }).orElse(null);
    }

    public static boolean insertHook(UpperBlockEntity tileEntityUpper) {
        Direction upperFacing = (Direction)tileEntityUpper.getBlockState().getValue((Property)UpperBlock.FACING);
        return InventoryCodeHooksTweaked.getAttachedItemHandler(tileEntityUpper.getLevel(), tileEntityUpper.getBlockPos(), upperFacing).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (InventoryCodeHooksTweaked.isFull(itemHandler)) {
                return false;
            }
            for (int i = 0; i < tileEntityUpper.getContainerSize(); ++i) {
                if (tileEntityUpper.getItem(i).isEmpty()) continue;
                ItemStack originalSlotContents = tileEntityUpper.getItem(i).copy();
                ItemStack insertStack = tileEntityUpper.removeItem(i, 1);
                ItemStack remainder = InventoryCodeHooksTweaked.putStackInInventoryAllSlots((BlockEntity)tileEntityUpper, destination, itemHandler, insertStack);
                if (remainder.isEmpty()) {
                    return true;
                }
                tileEntityUpper.setItem(i, originalSlotContents);
            }
            return false;
        }).orElse(false);
    }

    private static ItemStack putStackInInventoryAllSlots(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.isEmpty(); ++slot) {
            stack = InventoryCodeHooksTweaked.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).isEmpty()) {
            UpperBlockEntity destinationUpper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = InventoryCodeHooksTweaked.isEmpty(destInventory);
            if (itemstack.isEmpty()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.EMPTY;
                insertedItem = true;
            } else if (ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack)) {
                int originalSize = stack.getCount();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).getCount();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof UpperBlockEntity && !(destinationUpper = (UpperBlockEntity)destination).isOnCustomCooldown()) {
                int k = 0;
                if (source instanceof UpperBlockEntity && destinationUpper.getLastUpdateTime() >= ((UpperBlockEntity)source).getLastUpdateTime()) {
                    k = 1;
                }
                destinationUpper.setCooldown(8 - k);
            }
        }
        return stack;
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.isEmpty() && stackInSlot.getCount() == stackInSlot.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.getCount() <= 0) continue;
            return false;
        }
        return true;
    }

    private static Optional<Pair<IItemHandler, Object>> getAttachedItemHandler(Level level, BlockPos pos, Direction upperFacing) {
        double x = (double)pos.getX() + (double)upperFacing.getStepX();
        double y = (double)pos.getY() + (double)upperFacing.getStepY();
        double z = (double)pos.getZ() + (double)upperFacing.getStepZ();
        return InventoryCodeHooksTweaked.getItemHandlerAt(level, x, y, z, upperFacing.getOpposite());
    }

    private static Optional<Pair<IItemHandler, Object>> getSourceItemHandler(Level level, IUpper upper) {
        return InventoryCodeHooksTweaked.getItemHandlerAt(level, upper.getLevelX(), upper.getLevelY() - 1.0, upper.getLevelZ(), Direction.DOWN);
    }

    private static Optional<Pair<IItemHandler, Object>> getItemHandlerAt(Level worldIn, double x, double y, double z, Direction side) {
        BlockPos blockpos;
        BlockState state;
        BlockEntity blockEntity = (state = worldIn.getBlockState(blockpos = BlockPos.containing((double)x, (double)y, (double)z))).hasBlockEntity() ? worldIn.getBlockEntity(blockpos) : null;
        IItemHandler blockCap = (IItemHandler)worldIn.getCapability(Capabilities.ItemHandler.BLOCK, blockpos, state, blockEntity, (Object)side);
        if (blockCap != null) {
            return Optional.of(ImmutablePair.of((Object)blockCap, (Object)blockEntity));
        }
        List list = worldIn.getEntities((Entity)null, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelector.ENTITY_STILL_ALIVE);
        if (!list.isEmpty()) {
            Collections.shuffle(list);
            for (Entity entity : list) {
                IItemHandler entityCap = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)side);
                if (entityCap == null) continue;
                return Optional.of(ImmutablePair.of((Object)entityCap, (Object)entity));
            }
        }
        return Optional.empty();
    }
}

