/*
 * Decompiled with CFR 0.152.
 */
package net.juyoh.scale.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import java.util.List;
import java.util.Optional;
import net.juyoh.scale.Upsizing;
import net.juyoh.scale.recipe.ModRecipes;
import net.juyoh.scale.recipe.StretchingRecipe;
import net.juyoh.scale.recipe.StretchingRecipeInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PistonBaseBlock.class})
public class PistonPullMixin {
    @Shadow
    @Final
    private boolean isSticky;

    @Inject(method={"triggerEvent"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/event/EventHooks;onPistonMovePost(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Z)V")})
    public void render(BlockState state, Level level, BlockPos pos, int id, int param, CallbackInfoReturnable<Boolean> cir, @Local(name={"direction"}) Direction direction) {
        if (id != 0 && this.isSticky && !level.isClientSide) {
            BlockPos pullPos = pos.offset(direction.getStepX() * 2, direction.getStepY() * 2, direction.getStepZ() * 2);
            Block blockPulled = level.getBlockState(pullPos).getBlock();
            if (blockPulled == AllBlocks.DEPOT.get() && state.getValue((Property)BlockStateProperties.FACING) == Direction.DOWN) {
                DepotBlockEntity depot = (DepotBlockEntity)level.getBlockEntity(pullPos);
                ItemStack input = depot.getHeldItem();
                Upsizing.LOGGER.info("input: {}", (Object)input.toString());
                Optional recipeHolder = level.getServer().getRecipeManager().getRecipeFor((RecipeType)ModRecipes.STRETCHING_TYPE.get(), (RecipeInput)new StretchingRecipeInput(input), level);
                if (recipeHolder.isPresent()) {
                    ItemStack out = ((StretchingRecipe)((RecipeHolder)recipeHolder.get()).value()).output();
                    out.setCount(input.getCount());
                    Upsizing.LOGGER.info("output: {}", (Object)out.toString());
                    level.playSound(null, pullPos, SoundEvents.SLIME_JUMP_SMALL, SoundSource.MASTER, 1.0f, 1.0f);
                    depot.setHeldItem(((StretchingRecipe)((RecipeHolder)recipeHolder.get()).value()).output());
                    depot.notifyUpdate();
                }
            }
            List items = level.getEntities(EntityTypeTest.forClass(ItemEntity.class), AABB.encapsulatingFullBlocks((BlockPos)pullPos, (BlockPos)pullPos), itemEntity -> true);
            for (ItemEntity item : items) {
                Optional recipeHolder = level.getServer().getRecipeManager().getRecipeFor((RecipeType)ModRecipes.STRETCHING_TYPE.get(), (RecipeInput)new StretchingRecipeInput(item.getItem()), level);
                recipeHolder.ifPresent(stretchingRecipeRecipeHolder -> Upsizing.stretchItem(item, ((StretchingRecipe)stretchingRecipeRecipeHolder.value()).output().getItem()));
            }
        }
    }
}

