/*
 * Decompiled with CFR 0.152.
 */
package net.juyoh.scale.item;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.juyoh.scale.Config;
import net.juyoh.scale.Upsizing;
import net.juyoh.scale.item.ResizerRenderer;
import net.juyoh.scale.item.component.ModItemComponents;
import net.juyoh.scale.item.component.ResizerAmountComponent;
import net.juyoh.scale.screen.ResizerScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleTypes;

public class ResizerItem
extends Item {
    int lastUseTime = 0;

    public ResizerItem(Item.Properties properties) {
        super(properties);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (level.isClientSide) {
            if (player.isCrouching()) {
                this.openGUI(this, player, usedHand);
                return InteractionResultHolder.success((Object)stack);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        if (player.isCrouching()) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (Config.operatorRequired && !player.hasPermissions(player.getServer().getOperatorUserPermissionLevel())) {
            player.displayClientMessage((Component)Component.translatable((String)"message.upsizing.nopermission").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        if (BacktankUtil.canAbsorbDamage((LivingEntity)player, (int)256)) {
            float changeAmount = player.getXRot() < 0.0f ? ((ResizerAmountComponent)stack.get(ModItemComponents.RESIZER_COMPONENT)).scaleAmount() : -((ResizerAmountComponent)stack.get(ModItemComponents.RESIZER_COMPONENT)).scaleAmount();
            ScaleData data = ScaleTypes.BASE.getScaleData((Entity)player);
            float currentScale = data.getTargetScale();
            if (currentScale + changeAmount < 512.0f) {
                if (currentScale + changeAmount > 0.0f) {
                    BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (int)((int)Math.ceil(Math.abs(changeAmount))));
                    data.setTargetScale(currentScale + changeAmount);
                    this.lastUseTime = level.getServer().getTickCount();
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.upsizing.toosmall").withStyle(ChatFormatting.RED), true);
                }
                return InteractionResultHolder.success((Object)stack);
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.upsizing.toobig").withStyle(ChatFormatting.RED), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.upsizing.nopressure").withStyle(ChatFormatting.RED), true);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGUI(ResizerItem item, Player player, InteractionHand usedHand) {
        if (player instanceof LocalPlayer && player == Minecraft.getInstance().player) {
            ItemStack stack = player.getItemInHand(usedHand);
            if (stack.has((DataComponentType)ModItemComponents.RESIZER_COMPONENT.get())) {
                Minecraft.getInstance().setScreen((Screen)new ResizerScreen(item, usedHand, ((ResizerAmountComponent)stack.get((DataComponentType)ModItemComponents.RESIZER_COMPONENT.get())).scaleAmount()));
            } else {
                Minecraft.getInstance().setScreen((Screen)new ResizerScreen(item, usedHand));
            }
        }
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)256);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)256);
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)256);
    }

    @NotNull
    public Component getDescription() {
        List lines = TooltipHelper.cutStringTextComponent((String)Component.translatable((String)"create.tooltip.holdForDescription").toString(), (Style)Upsizing.greyPalette.primary(), (Style)Upsizing.greyPalette.highlight(), (int)1);
        if (Screen.hasShiftDown()) {
            lines.addAll(TooltipHelper.cutStringTextComponent((String)Component.translatable((String)"message.upsizing.resizer.tooltip.shift").toString(), (Style)Upsizing.goldPalette.primary(), (Style)Upsizing.goldPalette.highlight(), (int)2));
        }
        return Upsizing.joinComponents(lines);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new ResizerRenderer()));
    }
}

