/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.registry;

import com.github.jarva.arsadditions.common.item.AdvancedDominionWand;
import com.github.jarva.arsadditions.common.item.CodexEntry;
import com.github.jarva.arsadditions.common.item.CodexEntryAncient;
import com.github.jarva.arsadditions.common.item.CodexEntryLost;
import com.github.jarva.arsadditions.common.item.ExplorationWarpScroll;
import com.github.jarva.arsadditions.common.item.HandyHaversack;
import com.github.jarva.arsadditions.common.item.ImbuedSpellParchment;
import com.github.jarva.arsadditions.common.item.NexusWarpScroll;
import com.github.jarva.arsadditions.common.item.UnstableReliquary;
import com.github.jarva.arsadditions.common.item.Wayfinder;
import com.github.jarva.arsadditions.common.item.XPJar;
import com.github.jarva.arsadditions.common.item.curios.Charm;
import com.github.jarva.arsadditions.common.item.curios.StabilizedWarpIndex;
import com.github.jarva.arsadditions.common.item.curios.WarpIndex;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemRegistryWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AddonItemRegistry {
    public static final List<ItemRegistryWrapper<Item>> REGISTERED_ITEMS = new ArrayList<ItemRegistryWrapper<Item>>();
    public static final List<ItemRegistryWrapper<Item>> DATAGEN_ITEMS = new ArrayList<ItemRegistryWrapper<Item>>();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"ars_additions");
    public static final ItemRegistryWrapper<Item> LECTERN_REMOTE;
    public static final ItemRegistryWrapper<Item> ADVANCED_LECTERN_REMOTE;
    public static final ItemRegistryWrapper<Item> CODEX_ENTRY;
    public static final ItemRegistryWrapper<Item> CODEX_ENTRY_LOST;
    public static final ItemRegistryWrapper<Item> CODEX_ENTRY_ANCIENT;
    public static final ItemRegistryWrapper<Item> UNSTABLE_RELIQUARY;
    public static final ItemRegistryWrapper<Item> EXPLORATION_WARP_SCROLL;
    public static final ItemRegistryWrapper<Item> NEXUS_WARP_SCROLL;
    public static final ItemRegistryWrapper<Item> XP_JAR;
    public static final ItemRegistryWrapper<Item> HANDY_HAVERSACK;
    public static final ItemRegistryWrapper<Item> ADVANCED_DOMINION_WAND;
    public static final ItemRegistryWrapper<Item> WAYFINDER;
    public static final ItemRegistryWrapper<Item> IMBUED_SPELL_PARCHMENT;
    public static final HashMap<CharmRegistry.CharmType, ItemRegistryWrapper<Item>> CHARMS;

    private static void registerCharms() {
        for (CharmRegistry.CharmType charm : CharmRegistry.CharmType.values()) {
            CHARMS.put(charm, AddonItemRegistry.register(charm.getSerializedName(), () -> new Charm(charm.getCharges())));
        }
    }

    private static ItemRegistryWrapper<Item> register(String name, Supplier<Item> item) {
        return AddonItemRegistry.register(name, item, true);
    }

    private static ItemRegistryWrapper<Item> register(String name, Supplier<Item> item, boolean dataGen) {
        ItemRegistryWrapper registered = new ItemRegistryWrapper(ITEMS.register(name, item));
        REGISTERED_ITEMS.add((ItemRegistryWrapper<Item>)registered);
        if (dataGen) {
            DATAGEN_ITEMS.add((ItemRegistryWrapper<Item>)registered);
        }
        return registered;
    }

    public static Item.Properties defaultItemProperties() {
        return new Item.Properties();
    }

    static {
        CHARMS = new HashMap();
        LECTERN_REMOTE = AddonItemRegistry.register("warp_index", WarpIndex::new);
        ADVANCED_LECTERN_REMOTE = AddonItemRegistry.register("stabilized_warp_index", StabilizedWarpIndex::new);
        CODEX_ENTRY = AddonItemRegistry.register("codex_entry", CodexEntry::new);
        CODEX_ENTRY_LOST = AddonItemRegistry.register("lost_codex_entry", CodexEntryLost::new);
        CODEX_ENTRY_ANCIENT = AddonItemRegistry.register("ancient_codex_entry", CodexEntryAncient::new);
        UNSTABLE_RELIQUARY = AddonItemRegistry.register("unstable_reliquary", UnstableReliquary::new);
        EXPLORATION_WARP_SCROLL = AddonItemRegistry.register("exploration_warp_scroll", ExplorationWarpScroll::new);
        NEXUS_WARP_SCROLL = AddonItemRegistry.register("nexus_warp_scroll", NexusWarpScroll::new);
        XP_JAR = AddonItemRegistry.register("xp_jar", XPJar::new);
        HANDY_HAVERSACK = AddonItemRegistry.register("handy_haversack", HandyHaversack::new, false);
        ADVANCED_DOMINION_WAND = AddonItemRegistry.register("advanced_dominion_wand", AdvancedDominionWand::new);
        WAYFINDER = AddonItemRegistry.register("wayfinder", Wayfinder::new, false);
        IMBUED_SPELL_PARCHMENT = AddonItemRegistry.register("imbued_spell_parchment", ImbuedSpellParchment::new);
        AddonItemRegistry.registerCharms();
    }
}

