/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;

public class NoSolicitingBannerRenderer
extends BannerRenderer {
    static final Material BANNER_BASE = new Material(Sheets.BANNER_SHEET, ResourceLocation.fromNamespaceAndPath((String)"utilitarian", (String)"entity/no_soliciting_banner"));
    private final ModelPart flag;

    public NoSolicitingBannerRenderer(BlockEntityRendererProvider.Context pContext) {
        super(pContext);
        ModelPart modelpart = pContext.bakeLayer(ModelLayers.BANNER);
        this.flag = modelpart.getChild("flag");
    }

    public void render(BannerBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        long i;
        super.render(pBlockEntity, pPartialTick, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        pPoseStack.pushPose();
        if (pBlockEntity.getLevel() == null) {
            i = 0L;
            pPoseStack.translate(0.5f, 0.5f, 0.5f);
        } else {
            i = pBlockEntity.getLevel().getGameTime();
            BlockState blockstate = pBlockEntity.getBlockState();
            if (blockstate.getBlock() instanceof BannerBlock) {
                pPoseStack.translate(0.5f, 0.5f, 0.5f);
                float f1 = -RotationSegment.convertToDegrees((int)((Integer)blockstate.getValue((Property)BannerBlock.ROTATION)));
                pPoseStack.mulPose(Axis.YP.rotationDegrees(f1));
            } else {
                pPoseStack.translate(0.5f, -0.16666667f, 0.5f);
                float f3 = -((Direction)blockstate.getValue((Property)WallBannerBlock.FACING)).toYRot();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(f3));
                pPoseStack.translate(0.0f, -0.3125f, -0.4375f);
            }
        }
        pPoseStack.pushPose();
        pPoseStack.scale(0.6666667f, -0.6666667f, -0.6666667f);
        BlockPos blockpos = pBlockEntity.getBlockPos();
        float f2 = ((float)Math.floorMod((long)blockpos.getX() * 7L + (long)blockpos.getY() * 9L + (long)blockpos.getZ() * 13L + i, 100L) + pPartialTick) / 100.0f;
        this.flag.xRot = (-0.0125f + 0.01f * Mth.cos((float)((float)Math.PI * 2 * f2))) * (float)Math.PI;
        this.flag.y = -32.0f;
        this.flag.render(pPoseStack, BANNER_BASE.buffer(pBuffer, RenderType::entityNoOutline), pPackedLight, pPackedOverlay, 1);
        pPoseStack.popPose();
        pPoseStack.popPose();
    }
}

