/*
 * Decompiled with CFR 0.152.
 */
package observable.shadow.kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import observable.shadow.kotlinx.serialization.protobuf.ProtoIntegerType;
import observable.shadow.kotlinx.serialization.protobuf.internal.ByteArrayInput;
import observable.shadow.kotlinx.serialization.protobuf.internal.ProtobufDecodingException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0082\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\nJ\u0019\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019J\r\u0010\u001b\u001a\u00020\b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u001d\u00a2\u0006\u0004\b \u0010\u001fJ\r\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#J\r\u0010$\u001a\u00020!\u00a2\u0006\u0004\b$\u0010#J\r\u0010&\u001a\u00020%\u00a2\u0006\u0004\b&\u0010'J\r\u0010(\u001a\u00020%\u00a2\u0006\u0004\b(\u0010'J\u0015\u0010)\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b)\u0010\u0010J\r\u0010*\u001a\u00020\u0006\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b,\u0010+J\u0015\u0010-\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b-\u0010\u0013J\u000f\u0010.\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b.\u0010/J\r\u00100\u001a\u00020\u0011\u00a2\u0006\u0004\b0\u0010/J\r\u00102\u001a\u000201\u00a2\u0006\u0004\b2\u00103J\r\u00104\u001a\u000201\u00a2\u0006\u0004\b4\u00103J\r\u00105\u001a\u00020\u0006\u00a2\u0006\u0004\b5\u0010+J\r\u00106\u001a\u00020\b\u00a2\u0006\u0004\b6\u0010\u001cJ\u0017\u00108\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b8\u00109R\u0016\u0010:\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0016\u0010<\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010;R\u0011\u0010@\u001a\u00020=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010AR\u0016\u0010B\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0016\u0010D\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010;\u00a8\u0006E"}, d2={"Lobservable/shadow/kotlinx/serialization/protobuf/internal/ProtobufReader;", "", "Lobservable/shadow/kotlinx/serialization/protobuf/internal/ByteArrayInput;", "input", "<init>", "(Lkotlinx/serialization/protobuf/internal/ByteArrayInput;)V", "", "expected", "", "assertWireType", "(I)V", "length", "checkLength", "Lobservable/shadow/kotlinx/serialization/protobuf/ProtoIntegerType;", "format", "decode32", "(Lobservable/shadow/kotlinx/serialization/protobuf/ProtoIntegerType;)I", "", "decode64", "(Lobservable/shadow/kotlinx/serialization/protobuf/ProtoIntegerType;)J", "decodeSignedVarintInt", "(Lobservable/shadow/kotlinx/serialization/protobuf/internal/ByteArrayInput;)I", "decodeSignedVarintLong", "(Lobservable/shadow/kotlinx/serialization/protobuf/internal/ByteArrayInput;)J", "objectInput", "()Lobservable/shadow/kotlinx/serialization/protobuf/internal/ByteArrayInput;", "objectTaglessInput", "pushBackTag", "()V", "", "readByteArray", "()[B", "readByteArrayNoTag", "", "readDouble", "()D", "readDoubleNoTag", "", "readFloat", "()F", "readFloatNoTag", "readInt", "readInt32NoTag", "()I", "readIntLittleEndian", "readLong", "readLongLittleEndian", "()J", "readLongNoTag", "", "readString", "()Ljava/lang/String;", "readStringNoTag", "readTag", "skipElement", "header", "updateIdAndType", "(I)I", "currentId", "I", "currentType", "", "getEof", "()Z", "eof", "Lobservable/shadow/kotlinx/serialization/protobuf/internal/ByteArrayInput;", "pushBack", "Z", "pushBackHeader", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nProtobufReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufReader.kt\nkotlinx/serialization/protobuf/internal/ProtobufReader\n*L\n1#1,205:1\n70#1,2:206\n70#1,2:208\n70#1,2:210\n70#1,2:212\n70#1,2:214\n70#1,2:216\n70#1,2:218\n*S KotlinDebug\n*F\n+ 1 ProtobufReader.kt\nkotlinx/serialization/protobuf/internal/ProtobufReader\n*L\n74#1:206,2\n85#1:208,2\n97#1:210,2\n105#1:212,2\n112#1:214,2\n139#1:216,2\n148#1:218,2\n*E\n"})
public final class ProtobufReader {
    @NotNull
    private final ByteArrayInput input;
    @JvmField
    public int currentId;
    @JvmField
    public int currentType;
    private boolean pushBack;
    private int pushBackHeader;

    public ProtobufReader(@NotNull ByteArrayInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.currentId = -1;
        this.currentType = -1;
    }

    public final boolean getEof() {
        return !this.pushBack && this.input.getAvailableBytes() == 0;
    }

    public final int readTag() {
        if (this.pushBack) {
            int n;
            this.pushBack = false;
            int previousHeader = this.currentId << 3 | this.currentType;
            int it = n = this.updateIdAndType(this.pushBackHeader);
            boolean bl = false;
            this.pushBackHeader = previousHeader;
            return n;
        }
        this.pushBackHeader = this.currentId << 3 | this.currentType;
        int header = (int)this.input.readVarint64(true);
        return this.updateIdAndType(header);
    }

    private final int updateIdAndType(int header) {
        int n;
        if (header == -1) {
            this.currentId = -1;
            this.currentType = -1;
            n = -1;
        } else {
            this.currentId = header >>> 3;
            this.currentType = header & 7;
            n = this.currentId;
        }
        return n;
    }

    public final void pushBackTag() {
        this.pushBack = true;
        int nextHeader = this.currentId << 3 | this.currentType;
        this.updateIdAndType(this.pushBackHeader);
        this.pushBackHeader = nextHeader;
    }

    public final void skipElement() {
        switch (this.currentType) {
            case 0: {
                this.readInt(ProtoIntegerType.DEFAULT);
                break;
            }
            case 1: {
                this.readLong(ProtoIntegerType.FIXED);
                break;
            }
            case 2: {
                this.readByteArray();
                break;
            }
            case 5: {
                this.readInt(ProtoIntegerType.FIXED);
                break;
            }
            default: {
                throw new ProtobufDecodingException("Unsupported start group or end group wire type: " + this.currentType);
            }
        }
    }

    private final void assertWireType(int expected) {
        boolean $i$f$assertWireType = false;
        if (this.currentType != expected) {
            throw new ProtobufDecodingException("Expected wire type " + expected + ", but found " + this.currentType);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] readByteArray() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 2;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        return this.readByteArrayNoTag();
    }

    @NotNull
    public final byte[] readByteArrayNoTag() {
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readExactNBytes(length);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayInput objectInput() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 2;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        return this.objectTaglessInput();
    }

    @NotNull
    public final ByteArrayInput objectTaglessInput() {
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.slice(length);
    }

    public final int readInt(@NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        int wireType = format == ProtoIntegerType.FIXED ? 5 : 0;
        ProtobufReader this_$iv = this;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != wireType) {
            throw new ProtobufDecodingException("Expected wire type " + wireType + ", but found " + this_$iv.currentType);
        }
        return this.decode32(format);
    }

    public final int readInt32NoTag() {
        return ProtobufReader.decode32$default(this, null, 1, null);
    }

    public final long readLong(@NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        int wireType = format == ProtoIntegerType.FIXED ? 1 : 0;
        ProtobufReader this_$iv = this;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != wireType) {
            throw new ProtobufDecodingException("Expected wire type " + wireType + ", but found " + this_$iv.currentType);
        }
        return this.decode64(format);
    }

    public final long readLongNoTag() {
        return this.decode64(ProtoIntegerType.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public final float readFloat() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 5;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        return Float.intBitsToFloat(this.readIntLittleEndian());
    }

    public final float readFloatNoTag() {
        return Float.intBitsToFloat(this.readIntLittleEndian());
    }

    private final int readIntLittleEndian() {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int n = this.input.read() & 0xFF;
            result |= n << i * 8;
        }
        return result;
    }

    private final long readLongLittleEndian() {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            long l = this.input.read() & 0xFF;
            result |= l << i * 8;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final double readDouble() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 1;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        return Double.longBitsToDouble(this.readLongLittleEndian());
    }

    public final double readDoubleNoTag() {
        return Double.longBitsToDouble(this.readLongLittleEndian());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readString() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 2;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readString(length);
    }

    @NotNull
    public final String readStringNoTag() {
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readString(length);
    }

    private final void checkLength(int length) {
        if (length < 0) {
            throw new ProtobufDecodingException("Unexpected negative length: " + length);
        }
    }

    private final int decode32(ProtoIntegerType format) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                n = (int)this.input.readVarint64(false);
                break;
            }
            case 2: {
                n = this.decodeSignedVarintInt(this.input);
                break;
            }
            case 3: {
                n = this.readIntLittleEndian();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    static /* synthetic */ int decode32$default(ProtobufReader protobufReader, ProtoIntegerType protoIntegerType, int n, Object object) {
        if ((n & 1) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        return protobufReader.decode32(protoIntegerType);
    }

    private final long decode64(ProtoIntegerType format) {
        long l;
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                l = this.input.readVarint64(false);
                break;
            }
            case 2: {
                l = this.decodeSignedVarintLong(this.input);
                break;
            }
            case 3: {
                l = this.readLongLittleEndian();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    static /* synthetic */ long decode64$default(ProtobufReader protobufReader, ProtoIntegerType protoIntegerType, int n, Object object) {
        if ((n & 1) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        return protobufReader.decode64(protoIntegerType);
    }

    private final int decodeSignedVarintInt(ByteArrayInput input) {
        int raw = input.readVarint32();
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    private final long decodeSignedVarintLong(ByteArrayInput input) {
        long raw = input.readVarint64(false);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoIntegerType.values().length];
            try {
                nArray[ProtoIntegerType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoIntegerType.SIGNED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoIntegerType.FIXED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

