/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.block;

import com.jkvin114.displaydelight.DisplayDelight;
import com.jkvin114.displaydelight.block.AbstractStackablePlatedFoodBlock;
import com.jkvin114.displaydelight.block.SmallPlatedFoodBlock;
import com.jkvin114.displaydelight.init.BlockAssociations;
import com.jkvin114.displaydelight.init.DisplayConfig;
import com.jkvin114.displaydelight.init.DisplayItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractItemBlock
extends HorizontalDirectionalBlock {
    public AbstractItemBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        ItemStack stk = this.getStackFor();
        if (stk.getItem().equals(Items.AIR)) {
            stk = new ItemStack((ItemLike)state.getBlock().asItem());
        }
        return stk;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @NotNull
    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        List droppedStacks = super.getDrops(state, params);
        boolean silktouch = false;
        if (((Boolean)DisplayConfig.SILKTOUCH_DROPS_FOOD_BLOCK_ITEM.get()).booleanValue()) {
            try {
                Registry enchantmentRegistry = params.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
                ItemStack tool = (ItemStack)params.getParameter(LootContextParams.TOOL);
                if (tool.getEnchantmentLevel((Holder)enchantmentRegistry.getHolderOrThrow(Enchantments.SILK_TOUCH)) > 0) {
                    silktouch = true;
                }
            }
            catch (Exception e) {
                DisplayDelight.LOGGER.error(e.toString());
            }
        }
        Block block = state.getBlock();
        Item foodItem = this.getStackFor().getItem();
        boolean fallBack = false;
        if (block instanceof AbstractStackablePlatedFoodBlock) {
            AbstractStackablePlatedFoodBlock platedFoodBlock = (AbstractStackablePlatedFoodBlock)block;
            if (foodItem.equals(Items.AIR) || silktouch && platedFoodBlock.getStacks(state) >= platedFoodBlock.getMaxStackable()) {
                foodItem = this.asItem();
                fallBack = true;
            }
            droppedStacks.add(new ItemStack((ItemLike)foodItem, !fallBack ? platedFoodBlock.getStacks(state) : 1));
            if (!fallBack) {
                droppedStacks.add(new ItemStack(DisplayItems.PLATE));
            }
        } else if (block instanceof SmallPlatedFoodBlock) {
            if (foodItem.equals(Items.AIR) || silktouch) {
                foodItem = this.asItem();
                fallBack = true;
            }
            droppedStacks.add(new ItemStack((ItemLike)foodItem));
            if (!fallBack) {
                droppedStacks.add(new ItemStack(DisplayItems.SMALL_PLATE));
            }
        } else {
            if (foodItem.equals(Items.AIR) || silktouch) {
                foodItem = this.asItem();
            }
            droppedStacks.add(new ItemStack((ItemLike)foodItem));
        }
        return droppedStacks;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos.below(), Direction.UP, SupportType.CENTER);
    }

    public ItemStack getStackFor() {
        return new ItemStack((ItemLike)BlockAssociations.getItemFor((Block)this));
    }
}

