/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.init;

import com.jahirtrap.critterarmory.init.ModMaterials;
import com.jahirtrap.critterarmory.item.BaseAnimalArmorItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModContent {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"critterarmory");
    public static final List<DeferredItem<Item>> IRON_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.IRON, new Item.Properties());
    public static final List<DeferredItem<Item>> GOLD_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.GOLD, new Item.Properties());
    public static final List<DeferredItem<Item>> DIAMOND_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.DIAMOND, new Item.Properties());
    public static final List<DeferredItem<Item>> NETHERITE_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.NETHERITE, new Item.Properties().fireResistant());
    public static final DeferredItem<Item> BALANCED_FEED = ModContent.registerItem("balanced_feed", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> VITALITY_FEED = ModContent.registerItem("vitality_feed", () -> new Item(new Item.Properties()));

    private static DeferredItem<Item> registerItem(String name, Supplier<Item> supplier) {
        return ITEMS.register(name, supplier);
    }

    private static List<DeferredItem<Item>> registerMobArmors(Map.Entry<Holder<ArmorMaterial>, String> entry, Item.Properties itemProp) {
        ArrayList<DeferredItem<Item>> items = new ArrayList<DeferredItem<Item>>();
        if (entry.getKey() != ModMaterials.IRON.getKey() && entry.getKey() != ModMaterials.GOLD.getKey() && entry.getKey() != ModMaterials.DIAMOND.getKey()) {
            items.add(ModContent.registerItem(entry.getValue() + "_horse_armor", () -> new BaseAnimalArmorItem.Vanilla((Holder<ArmorMaterial>)((Holder)entry.getKey()), AnimalArmorItem.BodyType.EQUESTRIAN, itemProp)));
        }
        items.add(ModContent.registerItem(entry.getValue() + "_wolf_armor", () -> new BaseAnimalArmorItem.Vanilla((Holder<ArmorMaterial>)((Holder)entry.getKey()), AnimalArmorItem.BodyType.CANINE, itemProp)));
        items.add(ModContent.registerItem(entry.getValue() + "_cat_armor", () -> new BaseAnimalArmorItem.Modded((Holder<ArmorMaterial>)((Holder)entry.getKey()), BaseAnimalArmorItem.BodyType.CAT, itemProp)));
        items.add(ModContent.registerItem(entry.getValue() + "_chicken_armor", () -> new BaseAnimalArmorItem.Modded((Holder<ArmorMaterial>)((Holder)entry.getKey()), BaseAnimalArmorItem.BodyType.CHICKEN, itemProp)));
        items.add(ModContent.registerItem(entry.getValue() + "_cow_armor", () -> new BaseAnimalArmorItem.Modded((Holder<ArmorMaterial>)((Holder)entry.getKey()), BaseAnimalArmorItem.BodyType.COW, itemProp)));
        items.add(ModContent.registerItem(entry.getValue() + "_pig_armor", () -> new BaseAnimalArmorItem.Modded((Holder<ArmorMaterial>)((Holder)entry.getKey()), BaseAnimalArmorItem.BodyType.PIG, itemProp)));
        items.add(ModContent.registerItem(entry.getValue() + "_sheep_armor", () -> new BaseAnimalArmorItem.Modded((Holder<ArmorMaterial>)((Holder)entry.getKey()), BaseAnimalArmorItem.BodyType.SHEEP, itemProp)));
        return items;
    }

    public static void init(IEventBus bus) {
        ITEMS.register(bus);
    }
}

