/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.utils.pathfinding;

import com.heaser.pipeconnector.PipeConnector;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockEqualsChecker;
import com.heaser.pipeconnector.config.PipeConnectorConfig;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.TagUtils;
import com.heaser.pipeconnector.utils.pathfinding.PathfindingUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PathfindingAStarAlgorithm {
    public static List<BlockPos> findPathAStar(BlockPos start, BlockPos end, int endY, Level level, Player player, HeuristicChecker checker) {
        PriorityQueue<Node> openSet = new PriorityQueue<Node>();
        HashSet<BlockPos> closedSet = new HashSet<BlockPos>();
        HashMap<BlockPos, Node> nodes = new HashMap<BlockPos, Node>();
        Node startNode = new Node(start, null, 0, checker.heuristic(start, end, endY));
        nodes.put(start, startNode);
        openSet.add(startNode);
        int iterationLimit = (Integer)PipeConnectorConfig.MAX_ASTAR_ITERATIONS.get();
        int iterationCount = 0;
        while (!openSet.isEmpty()) {
            if (iterationCount++ > iterationLimit) {
                PipeConnector.LOGGER.warn("{}: Exceeded iteration limit on AStar algorithm", (Object)"pipe_connector");
                return null;
            }
            Node currentNode = (Node)openSet.poll();
            BlockPos currentPos = currentNode.position;
            if (closedSet.contains(currentPos)) continue;
            if (checker.isGoal(currentPos, end, endY)) {
                return PathfindingAStarAlgorithm.reconstructPath(nodes, currentNode);
            }
            closedSet.add(currentPos);
            for (BlockPos neighbor : PathfindingAStarAlgorithm.getNeighbors(currentPos, level, start, end, endY, player)) {
                if (closedSet.contains(neighbor)) continue;
                int tentativeGCost = currentNode.gCost + 1;
                Node neighborNode = (Node)nodes.get(neighbor);
                if (neighborNode == null) {
                    neighborNode = new Node(neighbor, currentPos, tentativeGCost, checker.heuristic(neighbor, end, endY));
                    nodes.put(neighbor, neighborNode);
                    openSet.add(neighborNode);
                    continue;
                }
                if (tentativeGCost >= neighborNode.gCost) continue;
                neighborNode.parent = currentPos;
                neighborNode.gCost = tentativeGCost;
                neighborNode.fCost = neighborNode.gCost + neighborNode.hCost;
                openSet.add(neighborNode);
            }
        }
        return null;
    }

    private static List<BlockPos> reconstructPath(Map<BlockPos, Node> nodes, Node endNode) {
        ArrayList<BlockPos> path = new ArrayList<BlockPos>();
        Node current = endNode;
        while (current != null) {
            path.add(current.position);
            current = nodes.get(current.parent);
        }
        Collections.reverse(path);
        return path;
    }

    private static List<BlockPos> getNeighbors(BlockPos pos, Level level, BlockPos start, BlockPos end, int endY, Player player) {
        BlockPos[] directions;
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>(6);
        for (BlockPos neighbor : directions = new BlockPos[]{pos.north(), pos.south(), pos.east(), pos.west(), pos.below(), pos.above()}) {
            if (!PathfindingAStarAlgorithm.shouldAddNeighbor(neighbor, start, end, endY, level, player)) continue;
            neighbors.add(neighbor);
        }
        return neighbors;
    }

    private static boolean shouldAddNeighbor(BlockPos neighbor, BlockPos start, BlockPos end, int endY, Level level, Player player) {
        boolean canAvoid;
        boolean isNotVoidable;
        boolean isStartOrEnd = PathfindingAStarAlgorithm.isStartOrEnd(neighbor, start, end);
        if (isStartOrEnd) {
            return true;
        }
        boolean isAtRequiredLevel = neighbor.getY() == endY;
        boolean bl = isNotVoidable = !GeneralUtils.isVoidableBlock(level, neighbor);
        if (!isAtRequiredLevel && !isNotVoidable) {
            return false;
        }
        ItemStack offhandItem = player.getOffhandItem();
        Block block = level.getBlockState(neighbor).getBlock();
        boolean bl2 = canAvoid = !GeneralUtils.isPipeBlock(level, neighbor) || GeneralUtils.isOffhandItemAvoidable(level, neighbor, player);
        if (!canAvoid) {
            return false;
        }
        boolean isBlockSpecificBlock = CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(neighbor, block, offhandItem, level);
        if (isBlockSpecificBlock) {
            return true;
        }
        boolean isCompatPassable = CompatibilityBlockEqualsChecker.isPassableForPathfinding(neighbor, level, offhandItem);
        if (isCompatPassable) {
            return true;
        }
        ItemStack connector = GeneralUtils.heldPipeConnector(player);
        if (connector != null && TagUtils.getAvoidInventoryBlocks(connector) && GeneralUtils.hasInventoryCapabilities(level, neighbor)) {
            return false;
        }
        return false;
    }

    private static boolean isStartOrEnd(BlockPos pos, BlockPos start, BlockPos end) {
        return pos.equals((Object)start) || pos.equals((Object)end);
    }

    static class Node
    implements Comparable<Node> {
        final BlockPos position;
        BlockPos parent;
        int gCost;
        final int hCost;
        int fCost;

        Node(BlockPos position, BlockPos parent, int gCost, int hCost) {
            this.position = position;
            this.parent = parent;
            this.gCost = gCost;
            this.hCost = hCost;
            this.fCost = gCost + hCost;
        }

        @Override
        public int compareTo(Node other) {
            return Integer.compare(this.fCost, other.fCost);
        }
    }

    public static interface HeuristicChecker {
        public int heuristic(BlockPos var1, BlockPos var2, int var3);

        public boolean isGoal(BlockPos var1, BlockPos var2, int var3);

        public void addDraftPlacements(List<BlockPos> var1);
    }

    public static class DepthHeuristicChecker
    implements HeuristicChecker {
        private final boolean useExistingPipes;
        private final Block placedBlock;
        private final ItemStack placedItemStack;
        private final Set<BlockPos> draftPlacements = new HashSet<BlockPos>();
        private final Level level;

        public DepthHeuristicChecker(boolean useExistingPipes, Block placedBlock, ItemStack placedItemStack, Level level) {
            this.useExistingPipes = useExistingPipes;
            this.placedBlock = placedBlock;
            this.placedItemStack = placedItemStack;
            this.level = level;
        }

        @Override
        public void addDraftPlacements(List<BlockPos> draftPlacements) {
            this.draftPlacements.addAll(draftPlacements);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public int heuristic(BlockPos current, BlockPos end, int endY) {
            cost = Math.abs(current.getY() - endY);
            if (!this.useExistingPipes) ** GOTO lbl-1000
            CompatibilityBlockEqualsChecker.getInstance();
            if (CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(current, this.placedBlock, this.placedItemStack, this.level)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = isExistingPipe = false;
            }
            if (isExistingPipe || this.draftPlacements.contains(current)) {
                return (int)((double)cost * 0.3);
            }
            return cost;
        }

        @Override
        public boolean isGoal(BlockPos current, BlockPos end, int endY) {
            return current.getY() == endY;
        }
    }

    public static class PositionHeuristicChecker
    implements HeuristicChecker {
        private final boolean useExistingPipes;
        private final Block placedBlock;
        private final ItemStack placedItemStack;
        private final Level level;
        private final Set<BlockPos> draftPlacements = new HashSet<BlockPos>();

        public PositionHeuristicChecker(boolean useExistingPipes, Block placedBlock, ItemStack placedItemStack, Level level) {
            this.useExistingPipes = useExistingPipes;
            this.placedBlock = placedBlock;
            this.placedItemStack = placedItemStack;
            this.level = level;
        }

        @Override
        public void addDraftPlacements(List<BlockPos> draftPlacements) {
            this.draftPlacements.addAll(draftPlacements);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public int heuristic(BlockPos current, BlockPos end, int endY) {
            cost = PathfindingUtils.getCost(current, end);
            if (!this.useExistingPipes) ** GOTO lbl-1000
            CompatibilityBlockEqualsChecker.getInstance();
            if (CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(current, this.placedBlock, this.placedItemStack, this.level)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = isExistingPipe = false;
            }
            if (isExistingPipe) {
                return (int)((double)cost * 0.3);
            }
            if (this.draftPlacements.contains(current)) {
                return (int)((double)cost * 0.1);
            }
            return cost;
        }

        @Override
        public boolean isGoal(BlockPos current, BlockPos end, int endY) {
            return current.equals((Object)end);
        }
    }
}

