/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.utils;

import com.heaser.pipeconnector.config.PipeConnectorConfig;
import com.heaser.pipeconnector.constants.TagKeys;
import com.heaser.pipeconnector.items.PipeConnectorItem;
import com.heaser.pipeconnector.utils.NodeParameter;
import com.heaser.pipeconnector.utils.TagUtils;
import java.time.LocalDateTime;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class GeneralUtils {
    public static boolean isServerSide(Level level) {
        return !level.isClientSide();
    }

    public static ItemStack heldPipeConnector(Player player) {
        if (GeneralUtils.isHoldingPipeConnector(player)) {
            return player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        return null;
    }

    public static boolean isHoldingPipeConnector(Player player) {
        return player.getItemInHand(InteractionHand.MAIN_HAND) != ItemStack.EMPTY && player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof PipeConnectorItem;
    }

    public static boolean isNotBreakable(Level level, BlockPos pos) {
        return level.getBlockState(pos).getDestroySpeed((BlockGetter)level, pos) == -1.0f && !level.getBlockState(pos).is(TagKeys.UNBREAKABLE_BLOCKS);
    }

    public static boolean isVoidableBlock(Level level, BlockPos pos) {
        return level.getBlockState(pos).is(TagKeys.VOIDABLE_BLOCKS);
    }

    public static boolean isPipeBlock(Level level, BlockPos pos) {
        return level.getBlockState(pos).is(TagKeys.PIPE_BLOCK);
    }

    public static boolean isOffhandItemAvoidable(Level level, BlockPos pos, Player player) {
        return level.getBlockState(pos).getBlock().asItem() == player.getOffhandItem().getItem().asItem();
    }

    public static boolean isPlaceableBlock(Player player) {
        return player.getOffhandItem().is(TagKeys.PLACEABLE_ITEMS);
    }

    public static boolean hasInventoryCapabilities(Level level, BlockPos pos) {
        IItemHandler capabilities;
        if (level.getBlockEntity(pos) != null && (capabilities = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
            int slotNum = capabilities.getSlots();
            return slotNum != 0;
        }
        return false;
    }

    public static boolean isAprilFoolsDay() {
        LocalDateTime now = LocalDateTime.now();
        return now.getMonthValue() == 4 && now.getDayOfMonth() == 1;
    }

    public static boolean MaxAllowedNodesReached(List<NodeParameter> nodes) {
        return nodes.size() >= (Integer)PipeConnectorConfig.MAX_ALLOWED_NODES.get();
    }

    public static void handleNodeRemovalByPosition(List<NodeParameter> nodes, BlockPos positionToRemove, ItemStack stack) {
        for (int index = 0; index < nodes.size(); ++index) {
            NodeParameter currentNode = nodes.get(index);
            if (!currentNode.position.equals((Object)positionToRemove)) continue;
            nodes.remove(currentNode);
            break;
        }
        TagUtils.setNodesToStack(stack, nodes);
    }
}

