/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.nasard;

import com.finchy.pipeorgans.ClientConfig;
import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import com.finchy.pipeorgans.content.pipes.generic.subtypes.DoublePipeBlockEntity;
import com.finchy.pipeorgans.content.pipes.nasard.NasardSoundInstance;
import com.finchy.pipeorgans.init.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class NasardBlockEntity
extends DoublePipeBlockEntity {
    @OnlyIn(value=Dist.CLIENT)
    protected NasardSoundInstance soundInstance;

    public NasardBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.baseBlock = AllBlocks.NASARD;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        String[] pitches = CreateLang.translateDirect((String)"generic.notes", (Object[])new Object[0]).getString().split(";");
        int displayPitch = ClientConfig.displayMutationSoundingPitch ? this.pitch + 5 : this.pitch;
        int octave = 5 - this.getOctave().ordinal() + (this.pitch <= 1 ? 1 : 0) + 2;
        boolean useBrackets = ClientConfig.showOctaveBrackets;
        Object octaveText = useBrackets ? "(" + octave + ")" : String.valueOf(octave);
        CreateLang.translate((String)"generic.pitch", (Object[])new Object[]{pitches[displayPitch % pitches.length]}).add(Component.literal((String)octaveText)).forGoggles(tooltip);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickAudio(EPipeSizes.PipeSize size, boolean powered) {
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.fadeOut();
                this.soundInstance = null;
            }
            return;
        }
        float f = (float)Math.pow(2.0, (double)(-this.pitch) / 12.0);
        boolean particle = this.level.getGameTime() % 8L == 0L;
        Vec3 eyePosition = Minecraft.getInstance().cameraEntity.getEyePosition();
        float maxVolume = (float)Mth.clamp((double)((64.0 - eyePosition.distanceTo(Vec3.atCenterOf((Vec3i)this.worldPosition))) / 64.0), (double)0.0, (double)1.0);
        if (this.soundInstance == null || this.soundInstance.isStopped() || this.soundInstance.getOctave() != size) {
            this.soundInstance = new NasardSoundInstance(size, this.worldPosition);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)this.soundInstance);
            AllSoundEvents.WHISTLE_CHIFF.playAt(this.level, (Vec3i)this.worldPosition, maxVolume * 0.1f, f, false);
            particle = true;
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(f);
        if (!particle) {
            return;
        }
        this.createSteamJet(size);
    }
}

